/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor.provider;

import java.util.Set;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.tools.api.profiler.SiriusTasksKey;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.ui.tools.internal.editor.DTreeViewer;

public class TreeUIUpdaterRunnable
implements Runnable {
    private DTreeViewer dTreeViewer;
    private Set<Object> toRefreshInViewer;
    private Object[] objectsToUpdateInViewer;
    private Set<DTreeItem> toExpand;
    private Set<DTreeItem> toCollapse;

    public TreeUIUpdaterRunnable(DTreeViewer dTreeViewer, Set<Object> toRefreshInViewer, Object[] objectsToUpdateInViewer, Set<DTreeItem> toExpand, Set<DTreeItem> toCollapse) {
        this.dTreeViewer = dTreeViewer;
        this.toRefreshInViewer = toRefreshInViewer;
        this.objectsToUpdateInViewer = objectsToUpdateInViewer;
        this.toExpand = toExpand;
        this.toCollapse = toCollapse;
    }

    @Override
    public void run() {
        if (this.dTreeViewer != null && this.dTreeViewer.getControl() != null && !this.dTreeViewer.getControl().isDisposed()) {
            for (Object object : this.toRefreshInViewer) {
                DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.REFRESH_SWT_LINE_KEY);
                this.dTreeViewer.refresh(object, true);
                DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.REFRESH_SWT_LINE_KEY);
            }
            for (Object object : this.toExpand) {
                DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.CHANGE_SWT_LINE_COLLAPSE_STATE_KEY);
                this.dTreeViewer.setExpandedState(object, true);
                DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.CHANGE_SWT_LINE_COLLAPSE_STATE_KEY);
            }
            for (Object object : this.toCollapse) {
                DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.CHANGE_SWT_LINE_COLLAPSE_STATE_KEY);
                this.dTreeViewer.setExpandedState(object, false);
                DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.CHANGE_SWT_LINE_COLLAPSE_STATE_KEY);
            }
            DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.UPDATE_SWT_LINE_KEY);
            this.dTreeViewer.update(this.objectsToUpdateInViewer, null);
            DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.UPDATE_SWT_LINE_KEY);
        }
    }
}

