/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.description.rules;

import org.apache.commons.lang3.function.FailableBiConsumer;
import org.eclipse.wb.core.databinding.xsd.component.MorphingType;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.MorphingTargetDescription;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.state.EditorState;

public final class MorphingTargetRule
implements FailableBiConsumer<ComponentDescription, MorphingType.MorphTarget, Exception> {
    private final EditorState m_state;
    private final ClassLoader m_classLoader;

    public MorphingTargetRule(EditorState state) {
        this.m_state = state;
        this.m_classLoader = this.m_state.getEditorLoader();
    }

    public void accept(ComponentDescription componentDescription, MorphingType.MorphTarget morphTarget) throws Exception {
        try {
            this.addTarget(componentDescription, morphTarget);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void addTarget(ComponentDescription componentDescription, MorphingType.MorphTarget morphTarget) throws ClassNotFoundException {
        String creationId = morphTarget.getCreationId();
        String className = morphTarget.getClazz();
        Assert.isNotNull((Object)className);
        Class<?> clazz = this.m_classLoader.loadClass(className);
        componentDescription.addMorphingTarget(new MorphingTargetDescription(clazz, creationId));
    }
}

