/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard.fragment;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.IClient;
import org.eclipse.wst.server.core.internal.ILaunchableAdapter;
import org.eclipse.wst.server.ui.internal.wizard.WizardTaskUtil;
import org.eclipse.wst.server.ui.internal.wizard.fragment.ModifyModulesWizardFragment;
import org.eclipse.wst.server.ui.internal.wizard.fragment.NewServerWizardFragment;
import org.eclipse.wst.server.ui.internal.wizard.fragment.OptionalClientWizardFragment;
import org.eclipse.wst.server.ui.internal.wizard.fragment.TasksWizardFragment;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class RunOnServerWizardFragment
extends WizardFragment {
    protected IServer server;
    protected IModule module;
    protected IModuleArtifact moduleArtifact;
    protected IClient client;
    protected ILaunchableAdapter launchable;
    private ModifyModulesWizardFragment modifyModulesWizardFragment;

    public RunOnServerWizardFragment(IModule module, String launchMode, IModuleArtifact moduleArtifact) {
        this.module = module;
        this.moduleArtifact = moduleArtifact;
    }

    public RunOnServerWizardFragment(IServer server, String launchMode, IModuleArtifact moduleArtifact) {
        this.server = server;
        this.moduleArtifact = moduleArtifact;
    }

    @Override
    protected void createChildFragments(List<WizardFragment> list) {
        if (this.server == null) {
            list.add(new NewServerWizardFragment(this.module));
            list.add(WizardTaskUtil.TempSaveRuntimeFragment);
            list.add(WizardTaskUtil.TempSaveServerFragment);
            this.modifyModulesWizardFragment = new ModifyModulesWizardFragment(this.module);
            list.add(this.modifyModulesWizardFragment);
        }
        list.add(new TasksWizardFragment());
        list.add(WizardTaskUtil.SaveRuntimeFragment);
        list.add(WizardTaskUtil.SaveServerFragment);
        if (this.server == null) {
            list.add(WizardTaskUtil.SaveHostnameFragment);
        }
        if (this.client == null || this.launchable == null) {
            list.add(new OptionalClientWizardFragment(this.moduleArtifact));
        }
    }

    public void setClient(IClient client) {
        this.client = client;
    }

    public void setLaunchable(ILaunchableAdapter launchable) {
        this.launchable = launchable;
    }

    public List<IModule> getModulesToRemove() {
        if (this.modifyModulesWizardFragment != null) {
            return this.modifyModulesWizardFragment.getModulesToRemove();
        }
        return new ArrayList<IModule>();
    }
}

