/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.compiler.env;

import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.compiler.env.ISourceType;
import org.eclipse.dltk.internal.compiler.env.AccessRestriction;

public class NameEnvironmentAnswer {
    private IModuleSource compilationUnit;
    private ISourceType[] sourceTypes;
    private AccessRestriction accessRestriction;

    public NameEnvironmentAnswer(IModuleSource compilationUnit, AccessRestriction accessRestriction) {
        this.compilationUnit = compilationUnit;
        this.accessRestriction = accessRestriction;
    }

    public NameEnvironmentAnswer(ISourceType[] sourceTypes, AccessRestriction accessRestriction) {
        this.sourceTypes = sourceTypes;
        this.accessRestriction = accessRestriction;
    }

    public AccessRestriction getAccessRestriction() {
        return this.accessRestriction;
    }

    public IModuleSource getSourceModule() {
        return this.compilationUnit;
    }

    public ISourceType[] getSourceTypes() {
        return this.sourceTypes;
    }

    public boolean isSourceModule() {
        return this.compilationUnit != null;
    }

    public boolean isSourceType() {
        return this.sourceTypes != null;
    }

    public boolean ignoreIfBetter() {
        return this.accessRestriction != null && this.accessRestriction.ignoreIfBetter();
    }

    public boolean isBetter(NameEnvironmentAnswer otherAnswer) {
        if (otherAnswer == null) {
            return true;
        }
        if (this.accessRestriction == null) {
            return true;
        }
        return otherAnswer.accessRestriction != null && this.accessRestriction.getProblemId() < otherAnswer.accessRestriction.getProblemId();
    }
}

