/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.core.edithelpers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.core.commands.RemoveBookmarkCommand;
import org.eclipse.gmf.runtime.diagram.core.internal.DiagramDebugOptions;
import org.eclipse.gmf.runtime.diagram.core.internal.DiagramPlugin;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;

public class RemoveBookmarksAdvice
extends AbstractEditHelperAdvice {
    private Set gatherSingleBookmark(EObject bookmarkedObject, Map fileResourceMap) {
        Resource eResource = null;
        if (bookmarkedObject == null || (eResource = bookmarkedObject.eResource()) == null) {
            return null;
        }
        IFile resource = null;
        if (fileResourceMap.containsKey(eResource)) {
            resource = (IFile)fileResourceMap.get(eResource);
        } else {
            resource = WorkspaceSynchronizer.getFile((Resource)eResource);
            fileResourceMap.put(eResource, resource);
        }
        if (resource == null) {
            return null;
        }
        if (eResource instanceof XMLResource) {
            String elementID = ((XMLResource)eResource).getID(bookmarkedObject);
            IMarker[] bookmarks = new IMarker[]{};
            try {
                bookmarks = resource.findMarkers("org.eclipse.gmf.runtime.common.ui.services.bookmark", true, 2);
            }
            catch (CoreException e) {
                Trace.catching((Plugin)DiagramPlugin.getInstance(), (String)DiagramDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"gatherSingleBookmark", (Throwable)e);
                Log.error((Plugin)DiagramPlugin.getInstance(), (int)4, (String)"gatherSingleBookmark");
            }
            HashSet<IMarker> retSet = new HashSet<IMarker>();
            int i = 0;
            while (i < bookmarks.length) {
                IMarker bookmark = bookmarks[i];
                String bookmarkElementID = bookmark.getAttribute("elementId", "");
                if (elementID.equals(bookmarkElementID)) {
                    retSet.add(bookmark);
                }
                ++i;
            }
            return retSet;
        }
        return new HashSet();
    }

    private Set gatherAllBookmarks(Set bookmarkedObjects, HashMap fileResourceMap) {
        Iterator iterBObjects = bookmarkedObjects.iterator();
        HashSet retSet = new HashSet();
        while (iterBObjects.hasNext()) {
            Set tempSet;
            Object oElement = iterBObjects.next();
            if (!(oElement instanceof EObject) || (tempSet = this.gatherSingleBookmark((EObject)oElement, fileResourceMap)) == null) continue;
            retSet.addAll(tempSet);
        }
        return retSet;
    }

    public ICommand getBeforeEditCommand(IEditCommandRequest request) {
        return null;
    }

    public ICommand getAfterEditCommand(IEditCommandRequest request) {
        if (request instanceof DestroyElementRequest) {
            return this.getAfterDestroyElementCommand((DestroyElementRequest)request);
        }
        return null;
    }

    protected ICommand getAfterDestroyElementCommand(DestroyElementRequest request) {
        RemoveBookmarkCommand result = null;
        Object oInitialDestructee = request.getParameter("DestroyElementRequest.initialElementToDestroy");
        if (oInitialDestructee != null && oInitialDestructee instanceof EObject && request.getElementToDestroy().equals(oInitialDestructee)) {
            Object oDependentElements = request.getParameter("DestroyElementRequest.destroyDependentsRequest");
            if (oDependentElements == null) {
                return null;
            }
            HashMap fileResourceMap = new HashMap();
            Set bookmarksItems = this.gatherAllBookmarks(((DestroyDependentsRequest)oDependentElements).getDependentElementsToDestroy(), fileResourceMap);
            Set bookmarksDestructee = this.gatherSingleBookmark(request.getElementToDestroy(), fileResourceMap);
            if (bookmarksDestructee != null) {
                bookmarksItems.addAll(bookmarksDestructee);
            }
            if (!bookmarksItems.isEmpty()) {
                result = new RemoveBookmarkCommand(request.getEditingDomain(), request.getLabel(), bookmarksItems);
            }
        }
        return result;
    }
}

