/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.blackbox.java;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnvFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalStdLibrary;
import org.eclipse.m2m.internal.qvt.oml.blackbox.LoadContext;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.DiagnosticUtil;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.Java2QVTTypeResolver;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.JavaBlackboxMessages;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.ModuleHandle;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.OperationBuilder;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtilPlugin;
import org.eclipse.m2m.internal.qvt.oml.expressions.Library;

abstract class JavaModuleLoader {
    private BasicDiagnostic fDiagnostics = null;
    private QvtOperationalModuleEnv fEnv;
    private OperationBuilder fOperBuilder;

    JavaModuleLoader() {
    }

    public QvtOperationalModuleEnv getLoadedModule() {
        return this.fEnv;
    }

    public Diagnostic getDiagnostics() {
        return this.fDiagnostics != null ? this.fDiagnostics : Diagnostic.OK_INSTANCE;
    }

    public Diagnostic loadModule(ModuleHandle moduleHandle, Map<String, List<EOperation>> definedOperations, LoadContext loadContext) {
        Class<?> javaClass;
        this.fDiagnostics = DiagnosticUtil.createRootDiagnostic(NLS.bind(JavaBlackboxMessages.LoadModuleDiagnostics, moduleHandle));
        try {
            javaClass = moduleHandle.getModuleJavaClass();
            if (!JavaModuleLoader.isModuleClassValid(javaClass)) {
                this.fDiagnostics.add((Diagnostic)DiagnosticUtil.createErrorDiagnostic(NLS.bind(JavaBlackboxMessages.InvalidJavaClassForModule, javaClass, moduleHandle)));
                return this.fDiagnostics;
            }
        }
        catch (ClassNotFoundException e) {
            this.fDiagnostics.add((Diagnostic)DiagnosticUtil.createErrorDiagnostic(NLS.bind(JavaBlackboxMessages.ModuleJavaClassNotFound, moduleHandle.getModuleName()), e));
            return this.fDiagnostics;
        }
        Library module = QvtOperationalStdLibrary.createLibrary(moduleHandle.getModuleName());
        this.fEnv = new QvtOperationalEnvFactory(loadContext.getMetamodelRegistry()).createModuleEnvironment(module);
        this.loadModule(this.fEnv, javaClass);
        LinkedHashSet<String> usedPackages = new LinkedHashSet<String>(moduleHandle.getUsedPackages());
        Java2QVTTypeResolver typeResolver = new Java2QVTTypeResolver(this.fEnv, usedPackages, this.fDiagnostics);
        this.fOperBuilder = new OperationBuilder(typeResolver);
        try {
            Method[] methods;
            Method[] methodArray = methods = javaClass.getDeclaredMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (JavaModuleLoader.isLibraryOperation(method)) {
                    EOperation operation = this.fOperBuilder.buildOperation(method);
                    Diagnostic operationStatus = this.fOperBuilder.getDiagnostics();
                    if (EmfUtilPlugin.isSuccess((Diagnostic)operationStatus)) {
                        this.loadOperation(operation, method);
                        List<EOperation> listOp = definedOperations.get(operation.getName());
                        if (listOp == null) {
                            listOp = new LinkedList<EOperation>();
                            definedOperations.put(operation.getName(), listOp);
                        }
                        listOp.add(operation);
                    }
                    if (operationStatus.getSeverity() != 0) {
                        this.fDiagnostics.add(operationStatus);
                    }
                }
                ++n2;
            }
        }
        catch (NoClassDefFoundError e) {
            this.fDiagnostics.add((Diagnostic)DiagnosticUtil.createErrorDiagnostic(NLS.bind(JavaBlackboxMessages.ModuleJavaClassNotLoadable, moduleHandle.getModuleName()), new Exception(e)));
            return this.fDiagnostics;
        }
        return this.fDiagnostics;
    }

    protected abstract void loadModule(QvtOperationalModuleEnv var1, Class<?> var2);

    protected abstract void loadOperation(EOperation var1, Method var2);

    private static boolean isLibraryOperation(Method method) {
        return Modifier.isPublic(method.getModifiers());
    }

    private static boolean isModuleClassValid(Class<?> javaClass) {
        Class[] noParams = new Class[]{};
        try {
            Constructor<?> constructor = javaClass.getDeclaredConstructor(noParams);
            if (!Modifier.isPublic(constructor.getModifiers())) {
            }
            return Modifier.isPublic(javaClass.getModifiers());
        }
        finally {
            return false;
        }
    }
}

