/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collections;

import java.util.Arrays;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.HashMapIntLong;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.inspections.collectionextract.AbstractExtractedCollection;
import org.eclipse.mat.inspections.collectionextract.CollectionExtractionUtils;
import org.eclipse.mat.inspections.collectionextract.ICollectionExtractor;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.internal.collectionextract.FieldSizeArrayCollectionExtractor;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.quantize.Quantize;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.extension.Subjects;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.RetainedSizeDerivedData;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

@CommandName(value="collections_grouped_by_size")
@Icon(value="/META-INF/icons/collection_size.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/analyzingjavacollectionusage.html")
@Subjects(value={"java.util.AbstractCollection", "java.util.jar.Attributes", "java.util.Dictionary", "java.lang.ThreadLocal$ThreadLocalMap", "java.util.concurrent.ConcurrentHashMap$Segment", "java.util.concurrent.ConcurrentHashMap$CollectionView", "java.util.concurrent.CopyOnWriteArrayList", "java.util.Collections$SynchronizedCollection", "java.util.Collections$SynchronizedMap", "java.util.Collections$UnmodifiableCollection", "java.util.Collections$UnmodifiableMap", "java.util.Collections$CheckedCollection", "java.util.Collections$CheckedMap$CheckedEntrySet", "java.util.Collections$SetFromMap", "java.util.Collections$EmptyList", "java.util.Collections$EmptySet", "java.util.Properties$EntrySet", "java.util.ResourceBundle", "java.awt.RenderingHints", "java.beans.beancontext.BeanContextSupport", "sun.awt.WeakIdentityHashMap", "javax.script.SimpleBindings", "javax.management.openmbean.TabularDataSupport", "com.ibm.jvm.util.HashMapRT", "com.sap.engine.lib.util.AbstractDataStructure", "org.eclipse.mat.collect.SetInt", "org.eclipse.mat.collect.SetLong", "org.eclipse.mat.collect.QueueInt", "org.eclipse.mat.collect.ArrayInt", "org.eclipse.mat.collect.ArrayLong", "org.eclipse.mat.collect.ArrayIntBig", "org.eclipse.mat.collect.ArrayLongBig", "java.util.AbstractMap", "java.util.jar.Attributes", "java.util.Dictionary", "java.lang.ThreadLocal$ThreadLocalMap", "java.util.concurrent.ConcurrentHashMap$Segment", "java.util.concurrent.ConcurrentHashMap$CollectionView", "java.util.Collections$SynchronizedMap", "java.util.Collections$UnmodifiableMap", "java.util.Collections$CheckedMap", "java.util.Collections$SetFromMap", "java.util.Collections$EmptyMap", "java.util.ResourceBundle", "java.beans.beancontext.BeanContextSupport", "sun.awt.WeakIdentityHashMap", "javax.script.SimpleBindings", "javax.management.openmbean.TabularDataSupport", "com.ibm.jvm.util.HashMapRT", "com.sap.engine.lib.util.AbstractDataStructure", "org.eclipse.mat.collect.HashMapIntLong", "org.eclipse.mat.collect.HashMapIntObject", "org.eclipse.mat.collect.HashMapLongObject", "org.eclipse.mat.collect.HashMapObjectLong"})
public class CollectionsBySizeQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IHeapObjectArgument objects;
    @Argument(isMandatory=false)
    public String collection;
    @Argument(isMandatory=false)
    public String size_attribute;

    public IResult execute(IProgressListener listener) throws Exception {
        FieldSizeArrayCollectionExtractor specificExtractor;
        listener.subTask(Messages.CollectionsBySizeQuery_CollectingSizes);
        if (this.size_attribute != null && this.collection != null) {
            specificExtractor = new FieldSizeArrayCollectionExtractor(this.size_attribute, this.collection);
        } else if (this.size_attribute == null && this.collection == null) {
            specificExtractor = null;
        } else {
            throw new IllegalArgumentException(Messages.CollectionsBySizeQuery_NeedSizeAndArrayOrNone);
        }
        Quantize.Builder builder = Quantize.valueDistribution((Column[])new Column[]{new Column(Messages.CollectionsBySizeQuery_Column_Length, Integer.TYPE).noTotals()});
        builder.column(Messages.CollectionsBySizeQuery_Column_NumObjects, Quantize.COUNT);
        builder.column(Messages.Column_ShallowHeap, Quantize.SUM_BYTES, Column.SortDirection.DESC);
        builder.addDerivedData(RetainedSizeDerivedData.APPROXIMATE);
        Quantize quantize = builder.build();
        this.runQuantizer(listener, quantize, specificExtractor, this.collection);
        return quantize.getResult();
    }

    private void runQuantizer(IProgressListener listener, Quantize quantize, ICollectionExtractor specificExtractor, String specificClass) throws SnapshotException {
        long LIMIT = 20L;
        HashMapIntLong exceptions = new HashMapIntLong();
        int counter = 0;
        IClass type = null;
        for (int[] objectIds : this.objects) {
            int objectId;
            HashMapIntObject resultMap = null;
            int[] sortedObjs = objectIds;
            int prev = Integer.MIN_VALUE;
            int[] nArray = objectIds;
            int n = objectIds.length;
            int n2 = 0;
            while (n2 < n) {
                objectId = nArray[n2];
                if (objectId < prev) {
                    sortedObjs = (int[])objectIds.clone();
                    Arrays.sort(sortedObjs);
                    resultMap = new HashMapIntObject();
                    break;
                }
                prev = objectId;
                ++n2;
            }
            nArray = sortedObjs;
            n = sortedObjs.length;
            n2 = 0;
            while (n2 < n) {
                block14: {
                    objectId = nArray[n2];
                    if (listener.isCanceled()) break;
                    IObject obj = this.snapshot.getObject(objectId);
                    if (counter++ % 1000 == 0 && !obj.getClazz().equals(type)) {
                        type = obj.getClazz();
                        listener.subTask(String.valueOf(Messages.CollectionsBySizeQuery_CollectingSizes) + "\n" + type.getName());
                    }
                    try {
                        Integer size;
                        AbstractExtractedCollection<?, ?> coll = CollectionExtractionUtils.extractCollection(obj, specificClass, specificExtractor);
                        if (coll != null && coll.hasSize() && (size = coll.size()) != null) {
                            if (resultMap != null) {
                                resultMap.put(objectId, (Object)new Result(size, coll.getUsedHeapSize()));
                            } else {
                                quantize.addValue(objectId, new Object[]{size, null, coll.getUsedHeapSize()});
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        int classId = obj.getClazz().getObjectId();
                        if (!exceptions.containsKey(classId)) {
                            exceptions.put(classId, 0L);
                        }
                        long c = exceptions.get(classId);
                        exceptions.put(classId, c + 1L);
                        if (c >= 20L) break block14;
                        listener.sendUserMessage(IProgressListener.Severity.INFO, MessageUtil.format((String)Messages.CollectionsBySizeQuery_IgnoringCollection, (Object[])new Object[]{obj.getTechnicalName()}), (Throwable)e);
                    }
                }
                ++n2;
            }
            if (resultMap != null) {
                nArray = objectIds;
                n = objectIds.length;
                n2 = 0;
                while (n2 < n) {
                    objectId = nArray[n2];
                    if (resultMap.containsKey(objectId)) {
                        Result r = (Result)resultMap.get(objectId);
                        quantize.addValue(objectId, new Object[]{r.size, null, r.used});
                    }
                    ++n2;
                }
            }
            if (listener.isCanceled()) break;
        }
    }

    private static class Result {
        final int size;
        final long used;

        public Result(int size, long used) {
            this.size = size;
            this.used = used;
        }
    }
}

