/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.TimeZone;

public class PRSDebug {
    public static boolean enableTracing = false;
    public static boolean enableFileCache = false;
    public static boolean noFileCache = true;
    public static boolean traceQueries = false;
    private static final long zerotime = System.currentTimeMillis();
    private static PrintStream traceout = null;
    private static int tracecount = 0;
    public static int QUERY_DELAY = 0;
    public static int ROW_DELAY = 0;
    public static int rowcount = 0;

    static {
        try {
            if (enableTracing) {
                String highLevelQualifier = "persistentResultSet";
                File traceFile = null;
                String tempDir = System.getProperty("java.io.tmpdir");
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
                sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                Random rnd = new Random(System.currentTimeMillis());
                StringBuffer rndStr = new StringBuffer(4);
                int i = 0;
                while (i < 4) {
                    rndStr.append((char)(rnd.nextInt(25) + 97));
                    ++i;
                }
                String uniqueQualifier = String.valueOf(sdf.format(new Date(System.currentTimeMillis()))) + "-" + rndStr;
                String filePath = String.valueOf(tempDir) + File.separator + "dsTrace." + highLevelQualifier + "." + uniqueQualifier;
                traceFile = new File(filePath);
                System.out.println(traceFile.getAbsolutePath());
                FileOutputStream fos = new FileOutputStream(traceFile, true);
                traceout = new PrintStream(fos);
                PRSDebug.trace("Tracing engaged");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    public static void debugQueryDelay() {
        PRSDebug.debugDelay(QUERY_DELAY);
    }

    public static void debugRowDelay() {
        PRSDebug.debugDelay(ROW_DELAY);
        ++rowcount;
    }

    public static void debugDelay(int delay) {
        try {
            if (delay > 0) {
                Thread.sleep(delay);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    public static void trace(String msg) {
        if (!enableTracing) {
            return;
        }
        long tid = Thread.currentThread().getId();
        int relativetime = (int)(System.currentTimeMillis() - zerotime);
        String pattern = "%1$04d %2$04d.%3$03d %4$03d";
        String ts = String.format(pattern, tid, relativetime / 1000, relativetime % 1000, tracecount++ % 1000);
        if (traceout != null) {
            traceout.println(String.valueOf(ts) + ": " + msg);
        }
        System.out.println(String.valueOf(ts) + ": " + msg);
    }

    public static String timestamp() {
        long diff = System.currentTimeMillis() - zerotime;
        int ms = (int)(diff % 1000L);
        int secs = (int)(diff / 1000L);
        int mins = secs / 60;
        return String.format("%d:%02d.%03d", mins, secs %= 60, ms);
    }
}

