/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.ui.ide.quickfix;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.preferences.EMFModelValidationPreferences;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.ui.ide.internal.l10n.ValidationUIIDEMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;

public class ValidationMarkerResolution
implements IMarkerResolutionGenerator {
    private static final IMarkerResolution[] EMPTY_RESOLUTIONS = new IMarkerResolution[0];

    public IMarkerResolution[] getResolutions(IMarker marker) {
        IConstraintDescriptor constraint;
        String constraintId = marker.getAttribute("rule", "");
        if (constraintId.length() > 0 && (constraint = ConstraintRegistry.getInstance().getDescriptor(constraintId)) != null && ValidationMarkerResolution.canFix(constraint)) {
            return new IMarkerResolution[]{new Resolution(constraint)};
        }
        return EMPTY_RESOLUTIONS;
    }

    private static boolean canFix(IConstraintDescriptor constraint) {
        boolean result = constraint.isEnabled();
        if (result) {
            Iterator iter = constraint.getCategories().iterator();
            while (result && iter.hasNext()) {
                boolean bl = result = !((Category)iter.next()).isMandatory();
            }
        }
        return result;
    }

    private static class Resolution
    implements IMarkerResolution {
        private final String label;
        private final IConstraintDescriptor constraint;

        public Resolution(IConstraintDescriptor constraint) {
            this.constraint = constraint;
            this.label = NLS.bind((String)ValidationUIIDEMessages.quickfix_label, (Object[])new Object[]{constraint.getName()});
        }

        public String getLabel() {
            return this.label;
        }

        public void run(IMarker marker) {
            EMFModelValidationPreferences.setConstraintDisabled((String)this.constraint.getId(), (boolean)true);
            EMFModelValidationPreferences.save();
        }
    }
}

