/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.custom.core.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.modisco.facet.custom.core.ICustomizationManager;
import org.eclipse.modisco.facet.custom.core.exception.CustomizationException;
import org.eclipse.modisco.facet.custom.core.internal.CustomizationsDelegatingList;
import org.eclipse.modisco.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.modisco.facet.efacet.core.IFacetManager;
import org.eclipse.modisco.facet.efacet.core.IFacetManagerFactory;
import org.eclipse.modisco.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.eclipse.modisco.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;

public class CustomizationManager
implements ICustomizationManager {
    private final HashSet<FacetOperation> customProperties = new HashSet();
    private final IFacetManager facetManager;

    public CustomizationManager(ResourceSet resourceSet) {
        this.facetManager = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager(resourceSet);
    }

    public CustomizationManager(IFacetManager facetManager) {
        this.facetManager = facetManager;
    }

    public void addFrontManagedCustomization(Customization customization) {
        this.facetManager.getManagedFacetSets().add(0, customization);
    }

    public void removeCustomization(Customization customization) {
        this.facetManager.getManagedFacetSets().remove(customization);
    }

    @Override
    public List<Customization> getManagedCustomizations() {
        return new CustomizationsDelegatingList(this.facetManager.getManagedFacetSets());
    }

    @Override
    public <T> T getCustomValueOf(EObject eObject, FacetOperation customizationProperty, Class<T> classs) throws CustomizationException {
        Object result = null;
        try {
            Object[] args = new Object[1];
            result = this.facetManager.invoke(eObject, (EOperation)customizationProperty, classs, null, args);
        }
        catch (Exception e) {
            throw new CustomizationException(e);
        }
        return (T)result;
    }

    @Override
    public <T> T getCustomValueOf(EObject eObject, ETypedElement eTypedElement, FacetOperation customizationProperty, Class<T> classs) throws CustomizationException {
        if (eObject == null) {
            throw new IllegalArgumentException("The parameter 'eObject' must not be null.");
        }
        if (customizationProperty == null) {
            throw new IllegalArgumentException("The parameter 'customizationProperty' must not be null.");
        }
        try {
            return (T)this.facetManager.invoke(eObject, (EOperation)customizationProperty, classs, null, new Object[]{eTypedElement});
        }
        catch (Exception e) {
            throw new CustomizationException(e);
        }
    }

    public List<FacetOperation> getCustomizationPropertiesByName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The parameter 'name' must not be null.");
        }
        ArrayList<FacetOperation> results = new ArrayList<FacetOperation>();
        for (FacetOperation customizationProperty : this.customProperties) {
            if (!name.equals(customizationProperty.getName())) continue;
            results.add(customizationProperty);
        }
        return results;
    }

    public void addCustomization(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("The parameter 'uri' must not be null.");
        }
        Resource resource = this.facetManager.getResourceSet().getResource(uri, true);
        TreeIterator iterator = resource.getAllContents();
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            if (!(eObject instanceof FacetOperation)) continue;
            FacetOperation customizationProperty = (FacetOperation)eObject;
            this.customProperties.add(customizationProperty);
        }
    }

    @Override
    public ResourceSet getResourceSet() {
        return this.facetManager.getResourceSet();
    }

    public void removeAllCustomizations() {
        LinkedList<Customization> customizationsToRemove = new LinkedList<Customization>();
        for (FacetSet facetSet : this.facetManager.getManagedFacetSets()) {
            if (!(facetSet instanceof Customization)) continue;
            Customization customization = (Customization)facetSet;
            customizationsToRemove.add(customization);
        }
        for (Customization customization : customizationsToRemove) {
            this.facetManager.getManagedFacetSets().remove(customization);
        }
    }

    @Override
    public IFacetManager getFacetManager() {
        return this.facetManager;
    }
}

