/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.junit.runtime;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.osgi.framework.Bundle;

class MultiBundleClassLoader
extends ClassLoader {
    private final List<Bundle> bundleList;

    public MultiBundleClassLoader(List<Bundle> platformEngineBundles) {
        super(null);
        this.bundleList = platformEngineBundles;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (Bundle temp : this.bundleList) {
            try {
                Class c = temp.loadClass(name);
                if (c == null) continue;
                return c;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected URL findResource(String name) {
        for (Bundle temp : this.bundleList) {
            URL url = temp.getResource(name);
            if (url == null) continue;
            try {
                return FileLocator.resolve((URL)url);
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        ArrayList<URL> merged = new ArrayList<URL>();
        for (Bundle bundle : this.bundleList) {
            Enumeration resources = bundle.getResources(name);
            while (resources != null && resources.hasMoreElements()) {
                merged.add(FileLocator.resolve((URL)((URL)resources.nextElement())));
            }
        }
        return Collections.enumeration(merged);
    }
}

