/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.graph.figures.layouts;

import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.xtext.xtext.ui.graph.figures.ISegmentFigure;

public class ParallelLayout
extends AbstractLayout {
    private int hmargin;

    public ParallelLayout(int hmargin) {
        this.hmargin = hmargin;
    }

    public ParallelLayout() {
        this(0);
    }

    public void layout(IFigure container) {
        if (container instanceof ISegmentFigure) {
            ISegmentFigure containerSegment = (ISegmentFigure)container;
            int width = 0;
            for (Object child : containerSegment.getChildren()) {
                if (!(child instanceof ISegmentFigure)) continue;
                Dimension childSize = ((ISegmentFigure)child).getPreferredSize();
                width = Math.max(width, childSize.width);
            }
            int y = 0;
            Rectangle bounds = Rectangle.SINGLETON;
            for (Object child : containerSegment.getChildren()) {
                if (!(child instanceof ISegmentFigure)) continue;
                Dimension childSize = ((ISegmentFigure)child).getPreferredSize();
                bounds.setLocation(20 + this.hmargin + (width - childSize.width) / 2, y);
                bounds.setSize(childSize);
                ((ISegmentFigure)child).setBounds(bounds);
                y += childSize.height + 9;
            }
            y = (y - 9) / 2;
            bounds.setLocation(this.hmargin, y);
            bounds.setSize(0, 0);
            containerSegment.getEntry().setBounds(bounds);
            bounds.setLocation(width + 40 + this.hmargin, y);
            containerSegment.getExit().setBounds(bounds);
        }
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        if (container instanceof ISegmentFigure) {
            ISegmentFigure containerSegment = (ISegmentFigure)container;
            int width = 0;
            int height = 0;
            for (Object child : containerSegment.getChildren()) {
                if (!(child instanceof ISegmentFigure)) continue;
                Dimension childSize = ((ISegmentFigure)child).getPreferredSize();
                width = Math.max(width, childSize.width);
                height += childSize.height + 9;
            }
            return new Dimension(width += 40 + 2 * this.hmargin + 1, height -= 9);
        }
        return new Dimension();
    }
}

