/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.emf.cdo.common.id.CDOIDExternal;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.internal.db.DBStoreTable;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBPreparedStatement;
import org.eclipse.net4j.db.IDBResultSet;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class ExternalReferenceManager
extends DBStoreTable {
    private static final DBType DEFAULT_URI_COLUMN_TYPE = DBType.VARCHAR;
    private static final int DEFAULT_URI_COLUMN_LENGTH = 1024;
    private static final int NULL = 0;
    private IDBField id;
    private IDBField uri;
    private IDBField committime;
    private AtomicLong lastMappedID = new AtomicLong(0L);
    @ReflectUtil.ExcludeFromDump
    private transient String sqlSelectByLongID;
    @ReflectUtil.ExcludeFromDump
    private transient String sqlSelectByURI;
    @ReflectUtil.ExcludeFromDump
    private transient String sqlInsert;

    public ExternalReferenceManager(IDBStore store) {
        super(store, NAMES.EXTERNAL_REFS);
    }

    public long mapExternalReference(CDOIDExternal id, long commitTime) {
        return this.mapURI(ExternalReferenceManager.accessor(), id.getURI(), commitTime);
    }

    public CDOIDExternal unmapExternalReference(long mappedId) {
        return CDOIDUtil.createExternal((String)this.unmapURI(ExternalReferenceManager.accessor(), mappedId));
    }

    public long mapURI(IDBStoreAccessor accessor, String uri, long commitTime) {
        long result = this.lookupByURI(accessor, uri);
        if (result < 0L) {
            return result;
        }
        return this.insertNew(accessor, uri, commitTime);
    }

    public String unmapURI(IDBStoreAccessor accessor, long mappedId) {
        String string;
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlSelectByLongID, IDBPreparedStatement.ReuseProbability.HIGH);
        IDBResultSet resultSet = null;
        try {
            stmt.setLong(1, mappedId);
            resultSet = stmt.executeQuery();
            if (!resultSet.next()) {
                OM.LOG.error("External ID " + mappedId + " not found. Database inconsistent!");
                throw new IllegalStateException("External ID " + mappedId + " not found. Database inconsistent!");
            }
            string = resultSet.getString(1);
        }
        catch (SQLException e) {
            try {
                throw new DBException((Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                DBUtil.close((Statement)stmt);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
        return string;
    }

    public long lookupByURI(IDBStoreAccessor accessor, String uri) {
        IDBResultSet resultSet;
        IDBPreparedStatement stmt;
        block4: {
            long l;
            stmt = accessor.getDBConnection().prepareStatement(this.sqlSelectByURI, IDBPreparedStatement.ReuseProbability.HIGH);
            resultSet = null;
            try {
                stmt.setString(1, uri);
                resultSet = stmt.executeQuery();
                if (!resultSet.next()) break block4;
                l = resultSet.getLong(1);
            }
            catch (SQLException ex) {
                try {
                    throw new DBException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    DBUtil.close(resultSet);
                    DBUtil.close((Statement)stmt);
                    throw throwable;
                }
            }
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)stmt);
            return l;
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
        return 0L;
    }

    public boolean deleteByURI(Statement statement, String uriValue) {
        try {
            return statement.execute("DELETE from " + this.table() + " WHERE " + this.uri + "='" + uriValue + "'");
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
    }

    public void rawExport(Connection connection, CDODataOutput out, long fromCommitTime, long toCommitTime) throws IOException {
        String where = " WHERE " + this.committime + " BETWEEN " + fromCommitTime + " AND " + toCommitTime;
        DBUtil.serializeTable((ExtendedDataOutput)out, (Connection)connection, (IDBTable)this.table(), null, (String)where);
    }

    public void rawImport(Connection connection, CDODataInput in, long fromCommitTime, long toCommitTime, OMMonitor monitor) throws IOException {
        DBUtil.deserializeTable((ExtendedDataInput)in, (Connection)connection, (IDBTable)this.table(), (OMMonitor)monitor);
    }

    @Override
    protected void firstActivate(IDBTable table) {
        DBType idColumnType = this.store().getIDHandler().getDBType();
        int idColumnLength = this.store().getIDColumnLength();
        Map<String, String> properties = this.store().getProperties();
        DBType uriColumnType = DBType.getTypeByKeyword((String)properties.getOrDefault("externalRefsURIColumnType", DEFAULT_URI_COLUMN_TYPE.getKeyword()));
        int uriColumnLength = Integer.parseInt(properties.getOrDefault("externalRefsURIColumnLength", Integer.toString(1024)));
        this.id = table.addField(NAMES.ID, idColumnType, idColumnLength, true);
        this.uri = table.addField(NAMES.URI, uriColumnType, uriColumnLength);
        this.committime = table.addField(NAMES.COMMITTIME, DBType.BIGINT);
        table.addIndex(IDBIndex.Type.PRIMARY_KEY, new IDBField[]{this.id});
        table.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{this.uri});
    }

    @Override
    protected void reActivate(IDBTable table) {
        this.id = table.getField(NAMES.ID);
        this.uri = table.getField(NAMES.URI);
        this.committime = table.getField(NAMES.COMMITTIME);
        String sql = "SELECT MIN(" + this.id + ") FROM " + table;
        IDBStoreAccessor writer = this.store().getWriter(null);
        IDBPreparedStatement stmt = writer.getDBConnection().prepareStatement(sql, IDBPreparedStatement.ReuseProbability.LOW);
        IDBResultSet resultSet = null;
        try {
            try {
                resultSet = stmt.executeQuery();
                if (resultSet.next()) {
                    this.lastMappedID.set(resultSet.getLong(1));
                }
            }
            catch (SQLException ex) {
                DBUtil.rollbackSilently((Connection)writer.getDBConnection());
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)stmt);
            writer.release();
        }
    }

    @Override
    protected void initSQL(IDBTable table) {
        this.sqlInsert = "INSERT INTO " + table + "(" + this.id + "," + this.uri + "," + this.committime + ") VALUES (?, ?, ?)";
        this.sqlSelectByURI = "SELECT " + this.id + " FROM " + table + " WHERE " + this.uri + "=?";
        this.sqlSelectByLongID = "SELECT " + this.uri + " FROM " + table + " WHERE " + this.id + "=?";
    }

    private long insertNew(IDBStoreAccessor accessor, String uri, long commitTime) {
        long newMappedID = this.lastMappedID.decrementAndGet();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlInsert, IDBPreparedStatement.ReuseProbability.MEDIUM);
        try {
            stmt.setLong(1, newMappedID);
            stmt.setString(2, uri);
            stmt.setLong(3, commitTime);
            DBUtil.update((PreparedStatement)stmt, (boolean)true);
            long l = newMappedID;
            return l;
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e);
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    private static final class NAMES {
        private static final String EXTERNAL_REFS = NAMES.name("cdo_external_refs");
        private static final String ID = NAMES.name("id");
        private static final String URI = NAMES.name("uri");
        private static final String COMMITTIME = NAMES.name("committime");

        private NAMES() {
        }

        private static String name(String name) {
            return DBUtil.name((String)name, ExternalReferenceManager.class);
        }
    }
}

