/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.internal.provider.custom;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.provider.ExtendedAdapterFactoryItemDelegator;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.compare.uml2.internal.StereotypeApplicationChange;
import org.eclipse.emf.compare.uml2.internal.UMLDiff;
import org.eclipse.emf.compare.uml2.internal.provider.custom.UMLDiffCustomItemProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public class StereotypeApplicationChangeCustomItemProvider
extends UMLDiffCustomItemProvider {
    private final ExtendedAdapterFactoryItemDelegator itemDelegator = new ExtendedAdapterFactoryItemDelegator(this.getRootAdapterFactory());

    public StereotypeApplicationChangeCustomItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public IStyledString.IComposedStyledString getStyledText(Object object) {
        String action;
        UMLDiff umlDiff = (UMLDiff)object;
        IStyledString.IComposedStyledString stereotypeText = this.getInternalText(object);
        switch (umlDiff.getKind()) {
            case ADD: {
                action = "applied";
                break;
            }
            case DELETE: {
                action = "unapplied";
                break;
            }
            case CHANGE: {
                action = "changed";
                break;
            }
            case MOVE: {
                action = "moved";
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported " + DifferenceKind.class.getSimpleName() + " value: " + umlDiff.getKind());
            }
        }
        return stereotypeText.append(" [stereotype " + action + "]", IStyledString.Style.DECORATIONS_STYLER);
    }

    private IStyledString.IComposedStyledString getInternalText(Object object) {
        UMLDiff umlDiff = (UMLDiff)object;
        Stereotype stereotype = ((StereotypeApplicationChange)umlDiff).getStereotype();
        if (stereotype == null) {
            stereotype = UMLUtil.getStereotype((EObject)umlDiff.getDiscriminant());
        }
        ComposedStyledString stereotypeText = new ComposedStyledString();
        if (stereotype != null) {
            stereotypeText.append(String.valueOf(this.itemDelegator.getText((Object)stereotype)) + ' ');
        } else if (umlDiff.getDiscriminant() instanceof NamedElement) {
            stereotypeText.append("Stereotype " + ((NamedElement)umlDiff.getDiscriminant()).getName() + ' ');
        } else {
            stereotypeText.append("Stereotype ");
        }
        return stereotypeText;
    }

    @Override
    public String getSemanticObjectLabel(Object object) {
        return this.getInternalText(object).getString();
    }
}

