/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.internal.repository.tools.Activator;
import org.eclipse.equinox.p2.internal.repository.tools.RepositoryAnalyzer;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.osgi.framework.BundleContext;

public class RepositoryAnalyzerApplication
implements IApplication {
    private URI uri = null;

    public Object start(IApplicationContext context) throws Exception {
        long start = System.currentTimeMillis();
        this.processArguments((String[])context.getArguments().get("application.args"));
        IProvisioningAgent agent = (IProvisioningAgent)ServiceHelper.getService((BundleContext)Activator.getBundleContext(), IProvisioningAgent.class);
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        IMetadataRepository repository = manager.loadRepository(this.uri, (IProgressMonitor)new NullProgressMonitor());
        RepositoryAnalyzer repositoryAnalyzer = new RepositoryAnalyzer(new IMetadataRepository[]{repository});
        IStatus status = repositoryAnalyzer.analyze((IProgressMonitor)new NullProgressMonitor());
        IStatus[] children = status.getChildren();
        long time = System.currentTimeMillis() - start;
        if (status.isOK()) {
            System.out.println("Repository Analyzer Finished succesfuly in " + time + " ms.");
        } else {
            System.out.println("Repository Analyzer Finished in " + time + " ms with status with errors.");
        }
        IStatus[] iStatusArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            if (child.isOK()) {
                System.out.print("[OK] ");
            } else {
                System.out.print("[Error] ");
            }
            System.out.println(child.getMessage());
            if (child.isMultiStatus() && child.getChildren() != null && child.getChildren().length > 0) {
                IStatus[] subChildren;
                IStatus[] iStatusArray2 = subChildren = child.getChildren();
                int n3 = subChildren.length;
                int n4 = 0;
                while (n4 < n3) {
                    IStatus subChild = iStatusArray2[n4];
                    System.out.println("   " + subChild.getMessage());
                    ++n4;
                }
            }
            ++n2;
        }
        return IApplication.EXIT_OK;
    }

    private void processArguments(String[] args) throws CoreException, URISyntaxException {
        int i = 0;
        while (i < args.length) {
            if (("-m".equals(args[i]) || "-metadataRepository".equals(args[i])) && i + 1 < args.length) {
                this.uri = new URI(args[i + 1]);
            }
            ++i;
        }
        this.validateLaunch();
    }

    private void validateLaunch() throws CoreException {
        if (this.uri == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.equinox.p2.transformer", "-metadataRepository <metadataURI> must be specified"));
        }
    }

    public void stop() {
    }
}

