/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.ui.dialogfields;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.jsf.common.ui.JSFUICommonPlugin;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.IStringButtonAdapter;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.StringButtonDialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogs.ResourceOnClasspathDialog;
import org.eclipse.jst.pagedesigner.properties.attrgroup.IElementContextable;
import org.eclipse.jst.pagedesigner.utils.StructuredModelUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class ClasspathResourceButtonDialogField
extends StringButtonDialogField
implements IElementContextable {
    private static final String[] PROPERTIES_FILES_SUFFIXS = new String[]{"properties"};

    public ClasspathResourceButtonDialogField() {
        super((IStringButtonAdapter)new MyStringButtonAdapter());
    }

    @Override
    public void setElementContext(IDOMNode ancester, IDOMElement element) {
        IProject prj = StructuredModelUtil.getProjectFor((IStructuredModel)ancester.getModel());
        IStringButtonAdapter adapter = this.getStringButtonAdapter();
        if (adapter instanceof MyStringButtonAdapter) {
            ((MyStringButtonAdapter)adapter)._project = prj;
        }
    }

    private static class MyStringButtonAdapter
    implements IStringButtonAdapter {
        private IProject _project;

        private MyStringButtonAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            this.browseButtonPressed(field);
        }

        private void browseButtonPressed(DialogField field) {
            if (field instanceof ClasspathResourceButtonDialogField) {
                String newValue;
                String oldValue;
                ClasspathResourceButtonDialogField classPathField = (ClasspathResourceButtonDialogField)field;
                Shell shell = field.getShell();
                ResourceOnClasspathDialog dialog = new ResourceOnClasspathDialog(shell, this.getJavaProject());
                dialog.setTitle(JSFUICommonPlugin.getResourceString((String)"DialogField.ResourceButton.SelectFile"));
                dialog.setSuffixs(PROPERTIES_FILES_SUFFIXS);
                if (dialog.open() == 0 && (oldValue = classPathField.getText()) != (newValue = (String)dialog.getResult()[0])) {
                    classPathField.setText(newValue);
                }
            }
        }

        private IJavaProject getJavaProject() {
            try {
                if (this._project != null && this._project.hasNature("org.eclipse.jdt.core.javanature")) {
                    return JavaCore.create((IProject)this._project);
                }
                return null;
            }
            catch (CoreException coreException) {
                return null;
            }
        }
    }
}

