/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.sourcelookup.containers;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.CompositeSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.DirectorySourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ExternalArchiveSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.php.internal.debug.core.sourcelookup.containers.PHPVariableSourceContainer;

public class PHPCompositeSourceContainer
extends CompositeSourceContainer {
    private IProject project;

    public PHPCompositeSourceContainer(IProject project, ILaunchConfiguration configuration) {
        this.project = project;
    }

    protected ISourceContainer[] createSourceContainers() throws CoreException {
        ArrayList<Object> containers = new ArrayList<Object>();
        ProjectSourceContainer projectContainer = new ProjectSourceContainer(this.project, false);
        containers.add(projectContainer);
        IBuildpathEntry[] entries = DLTKCore.create((IProject)this.project).getRawBuildpath();
        if (entries != null) {
            IBuildpathEntry[] iBuildpathEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildpathEntry element = iBuildpathEntryArray[n2];
                if (element.getEntryKind() == 1) {
                    path = element.getPath();
                    File file = new File(path.toOSString());
                    if (element.getContentKind() == 3) {
                        containers.add(new ExternalArchiveSourceContainer(file.getAbsolutePath(), false));
                    } else {
                        containers.add(new DirectorySourceContainer(file, false));
                    }
                } else if (element.getEntryKind() == 2) {
                    IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(element.getPath().lastSegment());
                    if (resource instanceof IProject) {
                        IProject includeProject = (IProject)resource;
                        containers.add(new ProjectSourceContainer(includeProject, false));
                    }
                } else if (element.getEntryKind() == 4) {
                    path = element.getPath();
                    containers.add((Object)new PHPVariableSourceContainer(path));
                }
                ++n2;
            }
        }
        ISourceContainer[] scontainers = new ISourceContainer[containers.size()];
        containers.toArray(scontainers);
        return scontainers;
    }

    public Object[] findSourceElements(String name) throws CoreException {
        IFile[] matches;
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(name);
        if (resource == null && Path.EMPTY.isValidPath(name) && (matches = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(URIUtil.toURI((IPath)new Path(name).makeAbsolute()))).length > 0) {
            resource = matches[0];
        }
        if (resource != null) {
            return new Object[]{resource};
        }
        Object[] objs = super.findSourceElements(name);
        return objs;
    }

    public String getName() {
        return null;
    }

    public ISourceContainerType getType() {
        return null;
    }
}

