/*******************************************************************************
 * Copyright (c) 2016 vogella GmbH and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Simon Scholz <simon.scholz@vogella.com> - initial API and implementation
 ******************************************************************************/

package org.eclipse.ui.internal.ide.handlers;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.dialogs.FilteredPreferenceDialog;

/**
 * PropertyTester which is able to test whether a FilteredPreferenceDialog on a
 * given shell shows a certain {@link IPreferencePage} by comparing the classes'
 * name to an expectedValue.
 *
 * @since 3.4
 */
public class PagePropertyTester extends PropertyTester {

	@Override
	public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
		if (receiver instanceof Shell shell) {
			if (shell.isDisposed()) {
				return false;
			}
			Object shellData = shell.getData();
			if (shellData instanceof FilteredPreferenceDialog propertyDialog) {
				IPreferencePage currentPage = propertyDialog.getCurrentPage();
				if (currentPage != null) {
					return currentPage.getClass().getName().equals(expectedValue);
				}
			}
		}

		return false;
	}

}
