/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.remoteserviceadmin;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.LogUtility;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.IRemoteServiceRegistration;
import org.eclipse.ecf.remoteservice.util.EndpointDescriptionPropertiesUtil;
import org.osgi.framework.ServiceReference;

public class PropertiesUtil {
    protected static final List osgiProperties = Arrays.asList("objectClass", "service.id", "service.bundleid", "service.scope", "component.id", "component.name", "endpoint.framework.uuid", "endpoint.id", "endpoint.service.id", "remote.configs.supported", "remote.intents.supported", "service.exported.configs", "service.exported.intents", "service.exported.intents.extra", "service.exported.interfaces", "service.imported", "service.imported.configs", "service.intents");
    protected static final List ecfProperties = Arrays.asList("ecf.robjectClass", "ecf.rsvc.id", "ecf.endpoint.connecttarget.id", "ecf.endpoint.id", "ecf.endpoint.id.ns", "ecf.endpoint.ts", "ecf.endpoint.idfilter.ids", "ecf.endpoint.rsfilter", "ecf.service.imported.valuetype");

    public static void testSerializable(Object value) throws Exception {
        new ObjectOutputStream(new ByteArrayOutputStream()).writeObject(value);
    }

    public static String verifyStringProperty(Map properties, String propName) {
        Object r = properties.get(propName);
        try {
            return (String)r;
        }
        catch (ClassCastException e) {
            IllegalArgumentException iae = new IllegalArgumentException("property value is not a String: " + propName);
            iae.initCause(e);
            throw iae;
        }
    }

    public static Object convertToStringPlusValue(List<String> values) {
        if (values == null) {
            return null;
        }
        int valuesSize = values.size();
        switch (valuesSize) {
            case 0: {
                return null;
            }
            case 1: {
                return values.get(0);
            }
        }
        return values.toArray(new String[valuesSize]);
    }

    public static String[] getStringArrayFromPropertyValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return new String[]{(String)value};
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value instanceof Collection) {
            return ((Collection)value).toArray(new String[0]);
        }
        return null;
    }

    public static String[] getExportedInterfaces(ServiceReference serviceReference, Map<String, ?> overridingProperties) {
        Object overridingPropValue = overridingProperties.get("service.exported.interfaces");
        if (overridingPropValue != null) {
            return PropertiesUtil.getExportedInterfaces(serviceReference, overridingPropValue);
        }
        return PropertiesUtil.getExportedInterfaces(serviceReference);
    }

    public static String[] getMatchingInterfaces(String[] origin, Object propValue) {
        if (propValue == null || origin == null) {
            return null;
        }
        boolean wildcard = propValue.equals("*");
        if (wildcard) {
            return origin;
        }
        String[] stringArrayValue = PropertiesUtil.getStringArrayFromPropertyValue(propValue);
        if (stringArrayValue == null) {
            return null;
        }
        if (stringArrayValue.length == 1 && stringArrayValue[0].equals("*")) {
            return origin;
        }
        List<String> originList = Arrays.asList(origin);
        int i = 0;
        while (i < origin.length - 1) {
            if (!originList.contains(stringArrayValue[i])) {
                throw new IllegalArgumentException("ObjectClass=" + String.valueOf(originList) + " does not contain interface=" + stringArrayValue[i]);
            }
            ++i;
        }
        return stringArrayValue;
    }

    private static String[] getExportedInterfaces(ServiceReference serviceReference, Object propValue) {
        if (propValue == null) {
            return null;
        }
        String[] objectClass = (String[])serviceReference.getProperty("objectClass");
        return PropertiesUtil.getMatchingInterfaces(objectClass, propValue);
    }

    public static String[] getExportedInterfaces(ServiceReference serviceReference) {
        return PropertiesUtil.getExportedInterfaces(serviceReference, serviceReference.getProperty("service.exported.interfaces"));
    }

    public static String[] getServiceIntents(ServiceReference serviceReference, Map overridingProperties) {
        String[] extraIntents;
        String[] exportedIntents;
        ArrayList<String> results = new ArrayList<String>();
        String[] intents = PropertiesUtil.getStringArrayFromPropertyValue(overridingProperties.get("service.intents"));
        if (intents == null) {
            intents = PropertiesUtil.getStringArrayFromPropertyValue(serviceReference.getProperty("service.intents"));
        }
        if (intents != null) {
            results.addAll(Arrays.asList(intents));
        }
        if ((exportedIntents = PropertiesUtil.getStringArrayFromPropertyValue(overridingProperties.get("service.exported.intents"))) == null) {
            exportedIntents = PropertiesUtil.getStringArrayFromPropertyValue(serviceReference.getProperty("service.exported.intents"));
        }
        if (exportedIntents != null) {
            results.addAll(Arrays.asList(exportedIntents));
        }
        if ((extraIntents = PropertiesUtil.getStringArrayFromPropertyValue(overridingProperties.get("service.exported.intents.extra"))) == null) {
            extraIntents = PropertiesUtil.getStringArrayFromPropertyValue(serviceReference.getProperty("service.exported.intents.extra"));
        }
        if (extraIntents != null) {
            results.addAll(Arrays.asList(extraIntents));
        }
        if (results.size() == 0) {
            return null;
        }
        return results.toArray(new String[results.size()]);
    }

    public static List getStringPlusProperty(Map properties, String key) {
        return EndpointDescriptionPropertiesUtil.getStringPlusProperty((Map)properties, (String)key);
    }

    public static Object getPropertyValue(ServiceReference serviceReference, String key) {
        return serviceReference == null ? null : serviceReference.getProperty(key);
    }

    public static Object getPropertyValue(ServiceReference serviceReference, Map<String, Object> overridingProperties, String key) {
        Object result = null;
        if (overridingProperties != null) {
            result = overridingProperties.get(key);
        }
        return result != null ? result : PropertiesUtil.getPropertyValue(serviceReference, key);
    }

    public static boolean isOSGiProperty(String key) {
        return osgiProperties.contains(key) || key.startsWith("endpoint.package.version.");
    }

    public static boolean isECFProperty(String key) {
        return ecfProperties.contains(key);
    }

    public static boolean isPrivateProperty(String key) {
        return key.startsWith(".");
    }

    public static boolean isReservedProperty(String key) {
        return PropertiesUtil.isOSGiProperty(key) || PropertiesUtil.isECFProperty(key) || PropertiesUtil.isPrivateProperty(key);
    }

    public static Map createMapFromDictionary(Dictionary input) {
        if (input == null) {
            return null;
        }
        HashMap result = new HashMap();
        Enumeration e = input.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object val = input.get(key);
            result.put(key, val);
        }
        return result;
    }

    public static Dictionary createDictionaryFromMap(Map propMap) {
        if (propMap == null) {
            return null;
        }
        Properties result = new Properties();
        for (Object key : propMap.keySet()) {
            Object val = propMap.get(key);
            if (key == null || val == null) continue;
            ((Dictionary)result).put(key, val);
        }
        return result;
    }

    public static Dictionary createSerializableDictionaryFromMap(Map propMap) {
        if (propMap == null) {
            return null;
        }
        Properties result = new Properties();
        for (Object key : propMap.keySet()) {
            Object val = propMap.get(key);
            if (key == null || val == null) continue;
            try {
                PropertiesUtil.testSerializable(val);
                ((Dictionary)result).put(key, val);
            }
            catch (Exception e) {
                LogUtility.logWarning("createSerializableDictionaryFromMap", "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/exceptions/catching", PropertiesUtil.class, "Cannot serialize value for " + String.valueOf(key) + ".  Removing from properties", e);
            }
        }
        return result;
    }

    public static Long getLongWithDefault(Map props, String key, Long def) {
        Object o = props.get(key);
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof String) {
            return Long.valueOf((String)o);
        }
        return def;
    }

    public static Integer getIntWithDefault(Map props, String key, Integer def) {
        Object o = props.get(key);
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof String) {
            return Integer.valueOf((String)o);
        }
        return def;
    }

    public static String[] getStringArrayWithDefault(Map<String, Object> properties, String key, String[] def) {
        Object o = properties.get(key);
        if (o instanceof String) {
            return new String[]{(String)o};
        }
        if (o instanceof String[]) {
            return (String[])o;
        }
        if (o instanceof List) {
            List l = (List)o;
            return l.toArray(new String[l.size()]);
        }
        return def;
    }

    public static String getStringWithDefault(Map props, String key, String def) {
        Object o = props.get(key);
        if (o == null || !(o instanceof String)) {
            return def;
        }
        return (String)o;
    }

    public static Map<String, Object> copyProperties(IRemoteServiceRegistration rsRegistration, Map<String, Object> target) {
        String[] keys = rsRegistration.getPropertyKeys();
        int i = 0;
        while (i < keys.length) {
            target.put(keys[i], rsRegistration.getProperty(keys[i]));
            ++i;
        }
        return target;
    }

    public static Map<String, Object> copyProperties(Map<String, Object> source, Map<String, Object> target) {
        for (String key : source.keySet()) {
            target.put(key, source.get(key));
        }
        return target;
    }

    public static Map<String, Object> copySerializableProperties(Map<String, ?> source, Map<String, Object> target) {
        if (source == null) {
            return target;
        }
        for (String key : source.keySet()) {
            Object value = source.get(key);
            try {
                PropertiesUtil.testSerializable(value);
                target.put(key, value);
            }
            catch (Exception e) {
                LogUtility.logWarning("copySerializableProperties", "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/exceptions/catching", PropertiesUtil.class, "Cannot serialize value for property=" + key + ". Removing from properties", e);
            }
        }
        return target;
    }

    public static Map<String, Object> copyProperties(ServiceReference serviceReference, Map<String, Object> target) {
        String[] keys = serviceReference.getPropertyKeys();
        int i = 0;
        while (i < keys.length) {
            target.put(keys[i], serviceReference.getProperty(keys[i]));
            ++i;
        }
        return target;
    }

    public static Map<String, Object> copyNonECFProperties(Map<String, Object> source, Map<String, Object> target) {
        for (String key : source.keySet()) {
            if (PropertiesUtil.isECFProperty(key)) continue;
            target.put(key, source.get(key));
        }
        return target;
    }

    public static Map<String, Object> copyNonReservedProperties(Map<String, Object> source, Map<String, Object> target) {
        for (String key : source.keySet()) {
            if (PropertiesUtil.isReservedProperty(key)) continue;
            target.put(key, source.get(key));
        }
        return target;
    }

    public static Map<String, Object> copyNonECFProperties(ServiceReference serviceReference, Map<String, Object> target) {
        String[] keys = serviceReference.getPropertyKeys();
        int i = 0;
        while (i < keys.length) {
            if (!PropertiesUtil.isECFProperty(keys[i])) {
                target.put(keys[i], serviceReference.getProperty(keys[i]));
            }
            ++i;
        }
        return target;
    }

    public static Map<String, Object> copyNonReservedProperties(ServiceReference serviceReference, Map<String, Object> target) {
        String[] keys = serviceReference.getPropertyKeys();
        int i = 0;
        while (i < keys.length) {
            if (!PropertiesUtil.isReservedProperty(keys[i])) {
                target.put(keys[i], serviceReference.getProperty(keys[i]));
            }
            ++i;
        }
        return target;
    }

    public static Map<String, Object> copyNonReservedProperties(IRemoteServiceReference rsReference, Map<String, Object> target) {
        String[] keys = rsReference.getPropertyKeys();
        int i = 0;
        while (i < keys.length) {
            if (!PropertiesUtil.isReservedProperty(keys[i])) {
                target.put(keys[i], rsReference.getProperty(keys[i]));
            }
            ++i;
        }
        return target;
    }

    public static Map mergeProperties(ServiceReference serviceReference, Map<String, Object> overrides) {
        return PropertiesUtil.mergeProperties(PropertiesUtil.copyProperties(serviceReference, new HashMap<String, Object>()), overrides);
    }

    public static Map mergePropertiesRaw(Map<String, Object> source, Map<String, Object> overrides) {
        return PropertiesUtil.mergeProperties0(source, overrides, true);
    }

    public static Map mergeProperties(Map<String, Object> source, Map<String, Object> overrides) {
        return PropertiesUtil.mergeProperties0(source, overrides, false);
    }

    public static Map mergeProperties0(Map<String, Object> source, Map<String, Object> overrides, boolean raw) {
        Map<String, Object> target = PropertiesUtil.copyProperties(source, new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER));
        for (String key : overrides.keySet()) {
            if (!raw && ("service.id".equals(key) || "objectClass".equals(key))) continue;
            target.remove(key);
            Object value = overrides.get(key);
            if (value == null) continue;
            target.put(key, value);
        }
        return target;
    }

    public static Long getOSGiEndpointModifiedValue(Map<String, Object> properties) {
        Object modifiedValue = properties.get("ecf.osgi.endpoint.modified");
        if (modifiedValue != null && modifiedValue instanceof String) {
            return Long.valueOf((String)modifiedValue);
        }
        return null;
    }

    public static boolean isConfigProperty(String config, String prop) {
        return prop.startsWith(config + ".");
    }

    public static Map<String, Object> removePrivateConfigProperties(String[] configs, Map<String, Object> source) {
        Map<String, Object> results = PropertiesUtil.copyProperties(source, new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER));
        Iterator<String> it = results.keySet().iterator();
        while (it.hasNext()) {
            int i = 0;
            while (i < configs.length) {
                String prop = it.next();
                if (PropertiesUtil.isConfigProperty(configs[i], prop) && prop.substring(configs[i].length() + 1).startsWith(".")) {
                    it.remove();
                }
                ++i;
            }
        }
        return results;
    }

    public static Map<String, Object> getConfigProperties(String config, Map<String, Object> source) {
        TreeMap<String, Object> results = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        for (String origKey : source.keySet()) {
            String key;
            if (!PropertiesUtil.isConfigProperty(config, origKey) || (key = origKey.substring(config.length() + 1)) == null) continue;
            results.put(key, source.get(origKey));
        }
        return results;
    }

    public static Map<String, Object> copyIntentProperties(Map<String, Object> source, String[] intents, Map<String, Object> target) {
        Map<String, Object> results = PropertiesUtil.copyProperties(target, new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER));
        String[] stringArray = intents;
        int n = intents.length;
        int n2 = 0;
        while (n2 < n) {
            String intent = stringArray[n2];
            results.put(intent, "intent");
            for (String sourceKey : source.keySet()) {
                if (!sourceKey.equals(intent) && !PropertiesUtil.isConfigProperty(intent, sourceKey)) continue;
                results.put(sourceKey, source.get(sourceKey));
            }
            ++n2;
        }
        return results;
    }

    public static Map<String, Object> copyNonIntentsProperties(IRemoteServiceReference rsReference, String[] intents, Map<String, Object> target) {
        List<String> intentsList = intents == null ? Collections.EMPTY_LIST : Arrays.asList(intents);
        String[] keys = rsReference.getPropertyKeys();
        int i = 0;
        while (i < keys.length) {
            if (!PropertiesUtil.isReservedProperty(keys[i]) && !intentsList.contains(keys[i])) {
                target.put(keys[i], rsReference.getProperty(keys[i]));
            }
            ++i;
        }
        return target;
    }
}

