/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.utils;

public final class UTF8Util {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String unwindEscapeChars(String s) {
        StringBuffer sb = new StringBuffer(s.length());
        int length = s.length();
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            sb.append(UTF8Util.getUnwoundString(c));
            ++i;
        }
        return sb.toString();
    }

    private static String getUnwoundString(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\"': {
                return "\\\"";
            }
            case '\'': {
                return "\\'";
            }
            case '\\': {
                return "\\\\";
            }
            case '=': {
                return "\\=";
            }
        }
        if (c < ' ' || c > '~') {
            return new StringBuffer().append('\\').append('u').append(UTF8Util.toHex(c >> 12 & 0xF)).append(UTF8Util.toHex(c >> 8 & 0xF)).append(UTF8Util.toHex(c >> 4 & 0xF)).append(UTF8Util.toHex(c & 0xF)).toString();
        }
        return String.valueOf(c);
    }

    private static char toHex(int halfByte) {
        return HEX_DIGITS[halfByte & 0xF];
    }

    private UTF8Util() {
    }
}

