/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.itemcreation;

import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.itemcreation.AbstractTagCreationAdvisor;
import org.eclipse.jst.pagedesigner.itemcreation.CreationData;
import org.eclipse.jst.pagedesigner.itemcreation.DefaultTagCreationAdvisor;
import org.eclipse.jst.pagedesigner.itemcreation.ITagCreationAdvisor;
import org.eclipse.jst.pagedesigner.itemcreation.ITagCreator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Element;

public abstract class AbstractTagCreator
implements ITagCreator {
    @Override
    public final Element createTag(CreationData creationData) {
        ITagCreationAdvisor advisor = this.selectCreationAdvisor(creationData);
        IDOMPosition position = advisor.checkAndApplyNecessaryContainers(creationData.getModel(), creationData.getDomPosition());
        if (position == null) {
            return null;
        }
        creationData.setAdjustedPosition(position);
        Element ele = this.createElement(creationData);
        if (ele == null) {
            return null;
        }
        advisor.applyCustomization(creationData.getModel(), ele);
        this.addTagToContainer(position, ele);
        return ele;
    }

    private ITagCreationAdvisor selectCreationAdvisor(CreationData creationData) {
        ITagCreationAdvisor advisor = this.doSelectCreationAdvisor(creationData);
        if (!(advisor instanceof AbstractTagCreationAdvisor)) {
            advisor = new DefaultTagCreationAdvisor(creationData);
        }
        return advisor;
    }

    protected abstract ITagCreationAdvisor doSelectCreationAdvisor(CreationData var1);

    protected final Element createElement(CreationData creationData) {
        Element ele = creationData.getModel().getDocument().createElement(creationData.getTagName());
        if (ele == null) {
            return null;
        }
        if ("jsp".equals(creationData.getUri()) && (ele.getLocalName().startsWith("directive.") || "declaration".equals(ele.getLocalName()) || "expression".equals(ele.getLocalName()) || "scriptlet".equals(ele.getLocalName()))) {
            ((IDOMElement)ele).setJSPTag(true);
        }
        if (creationData.getPrefix() != null) {
            ele.setPrefix(creationData.getPrefix());
        }
        return ele;
    }

    private void addTagToContainer(IDOMPosition position, Element tagElement) {
        if (position == null || position.getContainerNode() == null) {
            return;
        }
        if (position.getNextSiblingNode() == null) {
            position.getContainerNode().appendChild(tagElement);
        } else {
            position.getContainerNode().insertBefore(tagElement, position.getNextSiblingNode());
        }
    }
}

