/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.core.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.m2m.atl.core.IExtractor;
import org.eclipse.m2m.atl.core.IInjector;
import org.eclipse.m2m.atl.core.ModelFactory;
import org.eclipse.m2m.atl.core.launch.ILauncher;

public final class CoreService {
    private static final String LAUNCHERS_EXTENSION_POINT = "org.eclipse.m2m.atl.core.launcher";
    private static final String INJECTORS_EXTENSION_POINT = "org.eclipse.m2m.atl.core.injector";
    private static final String EXTRACTORS_EXTENSION_POINT = "org.eclipse.m2m.atl.core.extractor";
    private static final String MODELS_EXTENSION_POINT = "org.eclipse.m2m.atl.core.model";
    private static Map<String, Class<? extends ILauncher>> launcherRegistry = new HashMap<String, Class<? extends ILauncher>>();
    private static Map<String, Class<? extends IInjector>> injectorRegistry = new HashMap<String, Class<? extends IInjector>>();
    private static Map<String, Class<? extends IExtractor>> extractorRegistry = new HashMap<String, Class<? extends IExtractor>>();
    private static Map<String, Class<? extends ModelFactory>> factoryRegistry = new HashMap<String, Class<? extends ModelFactory>>();

    private CoreService() {
    }

    public static void registerLauncher(ILauncher launcher) {
        CoreService.registerLauncher(launcher.getName(), launcher.getClass());
    }

    public static void registerLauncher(String launcherName, Class<? extends ILauncher> launcherClass) {
        launcherRegistry.put(launcherName, launcherClass);
    }

    public static void registerInjector(String name, IInjector injector) {
        CoreService.registerInjector(name, injector.getClass());
    }

    public static void registerInjector(String injectorName, Class<? extends IInjector> injectorClass) {
        injectorRegistry.put(injectorName, injectorClass);
    }

    public static void registerExtractor(String name, IExtractor extractor) {
        CoreService.registerExtractor(name, extractor.getClass());
    }

    public static void registerExtractor(String extractorName, Class<? extends IExtractor> extractorClass) {
        extractorRegistry.put(extractorName, extractorClass);
    }

    public static void registerFactory(String name, Class<? extends ModelFactory> factoryClass) {
        factoryRegistry.put(name, factoryClass);
    }

    public static ModelFactory createModelFactory(String name) throws ATLCoreException {
        return CoreService.getModelFactory(name);
    }

    public static ModelFactory getModelFactory(String name) throws ATLCoreException {
        if (factoryRegistry.containsKey(name)) {
            try {
                return factoryRegistry.get(name).newInstance();
            }
            catch (IllegalAccessException e) {
                throw new ATLCoreException(e.getMessage(), e);
            }
            catch (InstantiationException e) {
                throw new ATLCoreException(e.getMessage(), e);
            }
        }
        ModelFactory factory = (ModelFactory)CoreService.getExtensionClass(MODELS_EXTENSION_POINT, "modelFactory", name);
        if (factory != null) {
            factoryRegistry.put(name, factory.getClass());
            return factory;
        }
        throw new ATLCoreException("org.eclipse.m2m.atl.core.model " + name + " not found, check the spelling or register it manually");
    }

    public static ILauncher getLauncher(String name) throws ATLCoreException {
        String realName = CoreService.getCompatibleLauncherName(name);
        if (launcherRegistry.containsKey(realName)) {
            try {
                return launcherRegistry.get(realName).newInstance();
            }
            catch (IllegalAccessException e) {
                throw new ATLCoreException(e.getMessage(), e);
            }
            catch (InstantiationException e) {
                throw new ATLCoreException(e.getMessage(), e);
            }
        }
        ILauncher launcher = (ILauncher)CoreService.getExtensionClass(LAUNCHERS_EXTENSION_POINT, "class", realName);
        if (launcher != null) {
            launcherRegistry.put(realName, launcher.getClass());
            return launcher;
        }
        throw new ATLCoreException("org.eclipse.m2m.atl.core.launcher " + realName + " not found, check the spelling or register it manually");
    }

    public static IInjector getInjector(String name) throws ATLCoreException {
        if (injectorRegistry.containsKey(name)) {
            try {
                return injectorRegistry.get(name).newInstance();
            }
            catch (IllegalAccessException e) {
                throw new ATLCoreException(e.getMessage(), e);
            }
            catch (InstantiationException e) {
                throw new ATLCoreException(e.getMessage(), e);
            }
        }
        IInjector injector = (IInjector)CoreService.getExtensionClass(INJECTORS_EXTENSION_POINT, "class", name);
        if (injector != null) {
            injectorRegistry.put(name, injector.getClass());
            return injector;
        }
        throw new ATLCoreException("org.eclipse.m2m.atl.core.injector " + name + " not found, check the spelling or register it manually");
    }

    public static IExtractor getExtractor(String name) throws ATLCoreException {
        if (extractorRegistry.containsKey(name)) {
            try {
                return extractorRegistry.get(name).newInstance();
            }
            catch (IllegalAccessException e) {
                throw new ATLCoreException(e.getMessage(), e);
            }
            catch (InstantiationException e) {
                throw new ATLCoreException(e.getMessage(), e);
            }
        }
        IExtractor extractor = (IExtractor)CoreService.getExtensionClass(EXTRACTORS_EXTENSION_POINT, "class", name);
        if (extractor != null) {
            extractorRegistry.put(name, extractor.getClass());
            return extractor;
        }
        throw new ATLCoreException("org.eclipse.m2m.atl.core.extractor " + name + " not found, check the spelling or register it manually");
    }

    private static Object getExtensionClass(String extensionId, String executableExtensionName, String extensionName) throws ATLCoreException {
        Object executable = null;
        if (Platform.isRunning()) {
            IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(extensionId).getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    if (configElements[j].getAttribute("name").equals(extensionName)) {
                        try {
                            executable = configElements[j].createExecutableExtension(executableExtensionName);
                        }
                        catch (CoreException e) {
                            throw new ATLCoreException(e.getMessage(), e);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return executable;
    }

    private static String[] getExtensionsNames(String extensionId) {
        ArrayList<String> names = new ArrayList<String>();
        if (Platform.isRunning()) {
            IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(extensionId).getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    names.add(configElements[j].getAttribute("name"));
                    ++j;
                }
                ++i;
            }
        }
        return names.toArray(new String[0]);
    }

    public static String[] getLaunchersNames() {
        return CoreService.getLaunchersNames(null);
    }

    public static String[] getLaunchersNames(String mode) {
        ArrayList<String> names = new ArrayList<String>();
        if (Platform.isRunning()) {
            IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(LAUNCHERS_EXTENSION_POINT).getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String launcherMode = configElements[j].getAttribute("mode");
                    if (mode == null || mode != null && (mode.equals(launcherMode) || launcherMode == null)) {
                        names.add(configElements[j].getAttribute("name").toString());
                    }
                    ++j;
                }
                ++i;
            }
        }
        Collections.sort(names);
        return names.toArray(new String[0]);
    }

    public static String[] getInjectorsNames() {
        return CoreService.getExtensionsNames(INJECTORS_EXTENSION_POINT);
    }

    public static String[] getExtractorsNames() {
        return CoreService.getExtensionsNames(EXTRACTORS_EXTENSION_POINT);
    }

    public static String[] getModelFactoriesNames() {
        return CoreService.getExtensionsNames(MODELS_EXTENSION_POINT);
    }

    public static Map<String, String> getLauncherOptions(String launcherName) {
        return CoreService.getLauncherOptions(launcherName, null);
    }

    public static Map<String, String> getLauncherOptions(String launcherName, String mode) {
        if (Platform.isRunning()) {
            IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(LAUNCHERS_EXTENSION_POINT).getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    if (launcherName.equals(configElements[j].getAttribute("name"))) {
                        HashMap<String, String> optionsMap = new HashMap<String, String>();
                        IConfigurationElement[] options = configElements[j].getChildren("option");
                        int k = 0;
                        while (k < options.length) {
                            String optionMode = options[k].getAttribute("mode");
                            if (mode == null || mode != null && (mode.equals(optionMode) || optionMode == null)) {
                                optionsMap.put(options[k].getAttribute("name"), options[k].getAttribute("description"));
                            }
                            ++k;
                        }
                        String parentLauncher = configElements[j].getAttribute("parent");
                        if (parentLauncher != null) {
                            optionsMap.putAll(CoreService.getLauncherOptions(parentLauncher, mode));
                        }
                        return optionsMap;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    public static String getCompatibleLauncherName(String name) {
        if (name.equals("Regular VM (with debugger)")) {
            return "Regular VM";
        }
        return name;
    }

    public static boolean isEclipseRunning() {
        try {
            return Platform.isRunning();
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

