/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.graphical.policies;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.Request;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.Layer;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.graphical.handles.Handle;
import org.eclipse.wb.gef.graphical.policies.GraphicalEditPolicy;
import org.eclipse.wb.gef.graphical.policies.ISelectionEditPolicyListener;

public abstract class SelectionEditPolicy
extends GraphicalEditPolicy {
    private final EditPartListener listener = new EditPartListener.Stub(){

        public void selectedStateChanged(org.eclipse.gef.EditPart part) {
            SelectionEditPolicy.this.selectionChanged(part.getSelected());
        }
    };
    private int m_selection = 0;
    private List<Handle> m_staticHandles;
    private List<Handle> m_handles;

    @Override
    public void activate() {
        super.activate();
        this.getHost().addEditPartListener(this.listener);
        this.showStaticHandles();
        this.selectionChanged(this.getHost().getSelected());
    }

    @Override
    public void deactivate() {
        this.getHost().removeEditPartListener(this.listener);
        this.selectionChanged(0);
        this.hideStaticHandles();
        super.deactivate();
    }

    private void selectionChanged(int selection) {
        if (this.m_selection != selection) {
            this.m_selection = selection;
            if (this.m_selection == 0) {
                this.hideSelection();
            } else {
                this.showSelection();
            }
        }
    }

    protected void showStaticHandles() {
        Layer layer = this.getLayer("Handle Layer Static");
        this.m_staticHandles = this.createStaticHandles();
        for (Handle handle : this.m_staticHandles) {
            layer.add((IFigure)handle);
        }
    }

    protected void hideStaticHandles() {
        if (this.m_staticHandles != null && !this.m_staticHandles.isEmpty()) {
            Layer layer = this.getLayer("Handle Layer Static");
            for (Handle handle : this.m_staticHandles) {
                layer.remove((IFigure)handle);
            }
            this.m_staticHandles = null;
        }
    }

    protected void showSelection() {
        this.hideSelection();
        Layer layer = this.getLayer("Handle Layer");
        this.m_handles = this.createSelectionHandles();
        for (Handle handle : this.m_handles) {
            layer.add((IFigure)handle);
        }
        this.fire_showSelection();
    }

    protected void hideSelection() {
        this.fire_hideSelection();
        if (this.m_handles != null) {
            for (Handle handle : this.m_handles) {
                FigureUtils.removeFigure((IFigure)handle);
            }
            this.m_handles = null;
        }
    }

    public void refreshSelection() {
        this.showSelection();
    }

    protected List<Handle> createStaticHandles() {
        return Collections.emptyList();
    }

    protected abstract List<Handle> createSelectionHandles();

    @Override
    public boolean understandsRequest(Request request) {
        return request.getType() == "selection";
    }

    public EditPart getTargetEditPart(Request request) {
        return this.getHost();
    }

    public void addSelectionPolicyListener(ISelectionEditPolicyListener listener) {
        this.getEnsureEventTable().addListener(ISelectionEditPolicyListener.class, (Object)listener);
    }

    public void removeSelectionPolicyListener(ISelectionEditPolicyListener listener) {
        this.getEnsureEventTable().removeListener(ISelectionEditPolicyListener.class, (Object)listener);
    }

    private void fire_showSelection() {
        Iterator<ISelectionEditPolicyListener> listeners = this.getListeners(ISelectionEditPolicyListener.class);
        if (listeners != null) {
            listeners.forEachRemaining(listener -> listener.showSelection(this));
        }
    }

    private void fire_hideSelection() {
        Iterator<ISelectionEditPolicyListener> listeners = this.getListeners(ISelectionEditPolicyListener.class);
        if (listeners != null) {
            listeners.forEachRemaining(listener -> listener.hideSelection(this));
        }
    }
}

