/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcessVisitor;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.ErrorList;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversal;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversalContext;

public class BP2111
extends AssertionProcessVisitor
implements WSITag {
    private final WSDLValidatorImpl validator;
    private boolean docLiteralFound = false;
    private ErrorList errors = new ErrorList();

    public BP2111(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public void visit(SOAPBinding binding, Object parent, WSDLTraversalContext ctx) {
        String style = binding.getStyle() == null ? "document" : binding.getStyle();
        ctx.addParameter("style", style);
    }

    @Override
    public void visit(SOAPOperation operation, Object parent, WSDLTraversalContext ctx) {
        String style = operation.getStyle();
        if (style == null) {
            style = (String)ctx.getParameter("style");
        }
        if (!"document".equals(style)) {
            ctx.cancelBindingOperationProcessing();
        }
    }

    @Override
    public void visit(SOAPBody body, Object parent, WSDLTraversalContext ctx) {
        if ("literal".equals(body.getUse())) {
            this.docLiteralFound = true;
            List parts = body.getParts();
            if (parts != null && parts.size() > 1) {
                this.errors.add(body.getElementType(), body.getNamespaceURI());
            }
        }
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "failed";
        WSDLTraversal traversal = new WSDLTraversal();
        traversal.setVisitor(this);
        traversal.visitSOAPBinding(true);
        traversal.visitSOAPBody(true);
        traversal.visitSOAPOperation(true);
        traversal.ignoreReferences();
        traversal.ignoreImport();
        traversal.traverse((Binding)entryContext.getEntry().getEntryDetail());
        if (!this.errors.isEmpty()) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(this.errors.toString(), entryContext);
        } else {
            this.result = !this.docLiteralFound ? "notApplicable" : "passed";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

