/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.executables;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.debug.core.executables.Executable;
import org.eclipse.cdt.debug.core.executables.ExecutablesManager;
import org.eclipse.cdt.debug.core.executables.IExecutablesChangeListener;
import org.eclipse.cdt.debug.core.executables.IExecutablesChangeListener2;
import org.eclipse.cdt.debug.internal.core.Trace;
import org.eclipse.cdt.debug.internal.ui.views.executables.Messages;
import org.eclipse.cdt.debug.internal.ui.views.executables.SourceFilesViewer;
import org.eclipse.cdt.ui.CElementContentProvider;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.WorkbenchJob;

public class SourceFilesContentProvider
extends CElementContentProvider
implements IExecutablesChangeListener2 {
    private Map<IPath, QuickParseJob> pathToJobMap = new HashMap<IPath, QuickParseJob>();
    private Map<IPath, TUData> fetchedExecutables = new HashMap<IPath, TUData>();
    private final SourceFilesViewer viewer;

    public SourceFilesContentProvider(SourceFilesViewer viewer) {
        super(true, true);
        this.viewer = viewer;
        ExecutablesManager.getExecutablesManager().addExecutablesChangeListener((IExecutablesChangeListener)this);
    }

    public void dispose() {
        ExecutablesManager.getExecutablesManager().removeExecutablesChangeListener((IExecutablesChangeListener)this);
        new WorkbenchJob(""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                SourceFilesContentProvider.this.fetchedExecutables.clear();
                SourceFilesContentProvider.this.pathToJobMap.clear();
                return Status.OK_STATUS;
            }
        }.schedule();
        super.dispose();
    }

    public boolean hasChildren(Object element) {
        SourceFilesViewer.TranslationUnitInfo info;
        if (element instanceof ITranslationUnit && (info = SourceFilesViewer.fetchTranslationUnitInfo((Executable)this.viewer.getInput(), element)) != null && !info.exists) {
            return false;
        }
        return super.hasChildren(element);
    }

    public Object[] getElements(Object inputElement) {
        if (Trace.DEBUG_EXECUTABLES) {
            Trace.getTrace().traceEntry(null, inputElement);
        }
        if (inputElement instanceof Executable) {
            final Executable executable = (Executable)inputElement;
            final IPath exePath = executable.getPath();
            QuickParseJob job = this.pathToJobMap.get(exePath);
            if (job != null) {
                return new String[]{Messages.SourceFilesContentProvider_Refreshing};
            }
            job = new QuickParseJob(executable);
            this.pathToJobMap.put(exePath, job);
            Object[] cachedResult = null;
            TUData tud = this.fetchedExecutables.get(exePath);
            if (tud != null) {
                cachedResult = tud.canceled ? new String[]{Messages.SourceFilesContentProvider_Canceled} : tud.tus;
            }
            if (cachedResult != null) {
                this.pathToJobMap.remove(exePath);
                return cachedResult;
            }
            final QuickParseJob theJob = job;
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(final IJobChangeEvent event) {
                    new WorkbenchJob("refreshing source files viewer"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (event.getResult().isOK()) {
                                (this).SourceFilesContentProvider.this.fetchedExecutables.put(exePath, new TUData(theJob.tus, theJob.executable.getResource().getModificationStamp()));
                            } else {
                                (this).SourceFilesContentProvider.this.fetchedExecutables.put(exePath, new TUData());
                            }
                            (this).SourceFilesContentProvider.this.pathToJobMap.values().remove((Object)theJob);
                            SourceFilesContentProvider.this.refreshViewer(executable);
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
            });
            job.schedule();
            return new String[]{Messages.SourceFilesContentProvider_Refreshing};
        }
        return new Object[0];
    }

    public void executablesListChanged() {
    }

    public void executablesChanged(final List<Executable> executables) {
        if (Trace.DEBUG_EXECUTABLES) {
            Trace.getTrace().traceEntry(null, executables);
        }
        new WorkbenchJob("Refreshing viewer"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                for (Executable executable : executables) {
                    IPath exePath = executable.getPath();
                    SourceFilesContentProvider.this.fetchedExecutables.remove(exePath);
                    QuickParseJob job = SourceFilesContentProvider.this.pathToJobMap.get(exePath);
                    if (job == null) continue;
                    if (Trace.DEBUG_EXECUTABLES) {
                        Trace.getTrace().trace(null, "Cancelling QuickParseJob: " + String.valueOf((Object)job));
                    }
                    job.cancel();
                    SourceFilesContentProvider.this.pathToJobMap.remove(exePath);
                }
                if (!SourceFilesContentProvider.this.viewer.getControl().isDisposed()) {
                    for (Executable executable : executables) {
                        if (!executable.equals(SourceFilesContentProvider.this.fInput)) continue;
                        Executable execInput = (Executable)SourceFilesContentProvider.this.fInput;
                        if (executable != execInput) {
                            execInput.setRefreshSourceFiles(true);
                        }
                        SourceFilesContentProvider.this.refreshViewer(execInput);
                        break;
                    }
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void inputChanged(Viewer viewer, Object oldInput, final Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        new WorkbenchJob("Refreshing viewer"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (newInput instanceof Executable && SourceFilesContentProvider.this.fetchedExecutables.containsKey(((Executable)newInput).getPath())) {
                    SourceFilesContentProvider.this.viewer.packColumns();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void executablesAdded(final List<Executable> executables) {
        if (Trace.DEBUG_EXECUTABLES) {
            Trace.getTrace().traceEntry(null, executables);
        }
        new WorkbenchJob("executables removed"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                for (Executable exec : executables) {
                    IPath exePath = exec.getPath();
                    long timestamp = exec.getResource().getModificationStamp();
                    TUData tud = SourceFilesContentProvider.this.fetchedExecutables.get(exePath);
                    if (tud == null || tud.timestamp == timestamp) continue;
                    SourceFilesContentProvider.this.fetchedExecutables.remove(exePath);
                }
                if (!SourceFilesContentProvider.this.viewer.getControl().isDisposed()) {
                    for (Executable executable : executables) {
                        if (!executable.equals(SourceFilesContentProvider.this.fInput)) continue;
                        if (Trace.DEBUG_EXECUTABLES) {
                            Trace.getTrace().trace(null, "refreshing viewer; added executable is our current input");
                        }
                        SourceFilesContentProvider.this.refreshViewer((Executable)SourceFilesContentProvider.this.fInput);
                        break;
                    }
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void executablesRemoved(final List<Executable> executables) {
        if (Trace.DEBUG_EXECUTABLES) {
            Trace.getTrace().traceEntry(null, executables);
        }
        new WorkbenchJob("executables removed"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                for (Executable exec : executables) {
                    IPath exePath = exec.getPath();
                    QuickParseJob job = SourceFilesContentProvider.this.pathToJobMap.get(exePath);
                    if (job == null) continue;
                    if (Trace.DEBUG_EXECUTABLES) {
                        Trace.getTrace().trace(null, "Cancelling QuickParseJob: " + String.valueOf((Object)job));
                    }
                    job.cancel();
                    SourceFilesContentProvider.this.pathToJobMap.remove(exePath);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void restartCanceledExecutableParse() {
        assert (Display.getCurrent() != null);
        Object input = this.viewer.getInput();
        if (input instanceof Executable) {
            final Executable executable = (Executable)input;
            final IPath exePath = executable.getPath();
            QuickParseJob job = this.pathToJobMap.get(exePath);
            if (job != null) {
                return;
            }
            TUData tud = this.fetchedExecutables.get(exePath);
            if (tud != null && !tud.canceled) {
                this.pathToJobMap.remove(exePath);
                return;
            }
            job = new QuickParseJob(executable);
            this.pathToJobMap.put(exePath, job);
            final QuickParseJob theJob = job;
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(final IJobChangeEvent event) {
                    new WorkbenchJob("refreshing source files viewer"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (event.getResult().isOK()) {
                                (this).SourceFilesContentProvider.this.fetchedExecutables.put(exePath, new TUData(theJob.tus, theJob.executable.getResource().getModificationStamp()));
                            } else {
                                (this).SourceFilesContentProvider.this.fetchedExecutables.put(exePath, new TUData());
                            }
                            (this).SourceFilesContentProvider.this.pathToJobMap.values().remove((Object)theJob);
                            SourceFilesContentProvider.this.refreshViewer(executable);
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
            });
            job.schedule();
            this.refreshViewer(executable);
        }
    }

    private void refreshViewer(Executable input) {
        if (!this.viewer.getControl().isDisposed()) {
            this.viewer.getTree().setLayoutDeferred(true);
            this.viewer.refresh(input);
            this.viewer.packColumns();
            this.viewer.getTree().setLayoutDeferred(false);
        }
    }

    static class QuickParseJob
    extends Job {
        final Executable executable;
        ITranslationUnit[] tus;

        public QuickParseJob(Executable executable) {
            super(Messages.SourceFilesContentProvider_ReadingDebugSymbolInformationLabel + executable.getName());
            this.executable = executable;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IStatus status;
            if (Trace.DEBUG_EXECUTABLES) {
                Trace.getTrace().trace(null, "Quick parsing of executable for source files has begun (" + String.valueOf((Object)this) + ")");
            }
            ITranslationUnit[] mytus = this.executable.getSourceFiles(monitor);
            if (!monitor.isCanceled()) {
                this.tus = mytus;
                status = Status.OK_STATUS;
            } else {
                status = Status.CANCEL_STATUS;
            }
            if (Trace.DEBUG_EXECUTABLES) {
                Trace.getTrace().trace(null, "Quick parsing of executable has finished, status is " + String.valueOf(status));
            }
            return status;
        }
    }

    private static class TUData {
        ITranslationUnit[] tus;
        long timestamp;
        boolean canceled;

        public TUData(ITranslationUnit[] tus, long timestamp) {
            this.tus = tus;
            this.timestamp = timestamp;
        }

        public TUData() {
            this.canceled = true;
        }
    }
}

