/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.internal.ui.wizards.BuildpathDetector;
import org.eclipse.dltk.ui.wizards.CapabilityConfigurationPage;
import org.eclipse.dltk.ui.wizards.IProjectWizard;
import org.eclipse.dltk.ui.wizards.IProjectWizardPage;
import org.eclipse.dltk.ui.wizards.ProjectCreator;
import org.eclipse.dltk.ui.wizards.ProjectWizard;
import org.eclipse.dltk.ui.wizards.ProjectWizardFirstPage;
import org.eclipse.dltk.ui.wizards.ProjectWizardUtils;
import org.eclipse.jface.preference.IPreferenceStore;

public class ProjectWizardSecondPage
extends CapabilityConfigurationPage
implements IProjectWizardPage {
    public static final String PAGE_NAME = "ProjectWizardSecondPage";
    private final ProjectWizardFirstPage firstPage;
    private final ProjectCreator.IProjectCreateStep initStep = new ProjectCreator.ProjectCreateStep(){

        @Override
        public void execute(IProject project, IProgressMonitor monitor) throws CoreException {
            IBuildpathEntry[] entries = ProjectWizardSecondPage.this.getCreator().initBuildpath(monitor);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            ProjectWizardSecondPage.this.init(DLTKCore.create((IProject)project), entries, false);
        }
    };
    private final ProjectCreator.IProjectCreateStep configureStep = new ProjectCreator.ProjectCreateStep(){

        @Override
        public void execute(IProject project, IProgressMonitor monitor) throws CoreException, InterruptedException {
            ProjectWizardSecondPage.this.configureScriptProject(monitor);
        }

        @Override
        public boolean isRecurrent() {
            return true;
        }
    };

    public ProjectWizardSecondPage(ProjectWizardFirstPage firstPage) {
        super(PAGE_NAME);
        this.firstPage = firstPage;
    }

    protected final ProjectCreator getCreator() {
        return this.getProjectWizard().getProjectCreator();
    }

    @Override
    protected boolean useNewSourcePage() {
        return true;
    }

    protected final IProjectWizard getProjectWizard() {
        return (IProjectWizard)this.getWizard();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            try {
                this.getProjectWizard().createProject();
            }
            catch (OperationCanceledException e) {
                this.getShell().close();
                return;
            }
        } else if (!ProjectWizardUtils.isProjectRequredFor(this.getContainer().getCurrentPage())) {
            this.getProjectWizard().removeProject();
        }
        super.setVisible(visible);
    }

    @Deprecated
    protected final BuildpathDetector createBuildpathDetector(IProgressMonitor monitor, IDLTKLanguageToolkit toolkit) {
        return null;
    }

    @Override
    protected final String getScriptNature() {
        return this.firstPage.getScriptNature();
    }

    @Deprecated
    protected final IPreferenceStore getPreferenceStore() {
        return null;
    }

    @Override
    public void initProjectWizardPage() {
        ProjectCreator creator = this.getCreator();
        creator.addStep("initUI", -1, this.initStep, this);
        creator.addStep("finish", -1, this.configureStep, this);
    }

    @Override
    public void updateProjectWizardPage() {
    }

    @Override
    public void resetProjectWizardPage() {
        IProjectWizard wizard = this.getProjectWizard();
        this.init(DLTKCore.create((IProject)wizard.getProject()), null, false);
    }

    @Override
    protected void configureNatures(IProject project, IProgressMonitor monitor) throws CoreException {
        ((ProjectWizard)this.getWizard()).configureNatures(project, monitor);
    }

    @Override
    protected void configureProject(IProject project, IProgressMonitor monitor) throws CoreException {
        super.configureProject(project, monitor);
        ((ProjectWizard)this.getWizard()).configureProject(project, monitor);
    }
}

