/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.printing.render.actions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.action.actions.IPrintActionHelper;
import org.eclipse.gmf.runtime.common.ui.services.editor.EditorService;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IDiagramPreferenceSupport;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.util.SWTDiagramPrinter;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.internal.DiagramUIPrintingRenderDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.internal.DiagramUIPrintingRenderPlugin;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.internal.JPSDiagramPrinter;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.internal.JPSDiagramPrinterHelper;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.util.RenderedDiagramPrinter;
import org.eclipse.gmf.runtime.diagram.ui.printing.util.DiagramPrinterUtil;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class EnhancedPrintActionHelper
implements IPrintActionHelper {
    public void doPrint(IWorkbenchPart workbenchPart) {
        IMapMode mapMode;
        DiagramEditor diagramEditor = null;
        if (!(workbenchPart instanceof DiagramEditor)) {
            Log.error((Plugin)DiagramUIPrintingRenderPlugin.getInstance(), (int)4, (String)"Invalid IWorkbenchPart");
            IllegalArgumentException e = new IllegalArgumentException("Invalid IWorkbenchPart.");
            Trace.throwing((Plugin)DiagramUIPrintingRenderPlugin.getInstance(), (String)DiagramUIPrintingRenderDebugOptions.EXCEPTIONS_THROWING, EnhancedPrintActionHelper.class, (String)"doPrint()", (Throwable)e);
            throw e;
        }
        diagramEditor = (DiagramEditor)workbenchPart;
        IDiagramGraphicalViewer viewer = diagramEditor.getDiagramGraphicalViewer();
        RootEditPart rootEP = viewer == null ? null : viewer.getRootEditPart();
        PreferencesHint preferencesHint = rootEP instanceof IDiagramPreferenceSupport ? ((IDiagramPreferenceSupport)rootEP).getPreferencesHint() : PreferencesHint.USE_DEFAULTS;
        IMapMode iMapMode = mapMode = rootEP instanceof DiagramRootEditPart ? ((DiagramRootEditPart)rootEP).getMapMode() : MapModeUtil.getMapMode();
        if (Platform.getOS().startsWith("win32") && Platform.getOSArch().equals("x86")) {
            DiagramPrinterUtil.printWithSettings((IEditorPart)diagramEditor, this.createDiagramMap(), (SWTDiagramPrinter)new RenderedDiagramPrinter(preferencesHint, mapMode));
        } else {
            JPSDiagramPrinterHelper.getDiagramPrinterHelper().printWithSettings((IEditorPart)diagramEditor, this.createDiagramMap(), new JPSDiagramPrinter(preferencesHint, mapMode));
        }
    }

    protected Map<String, Diagram> createDiagramMap() {
        HashMap<String, Diagram> diagramMap = new HashMap<String, Diagram>();
        List diagramEditors = EditorService.getInstance().getRegisteredEditorParts();
        for (Object obj : diagramEditors) {
            if (!(obj instanceof DiagramEditor)) continue;
            DiagramEditor dEditor = (DiagramEditor)obj;
            String diagramName = null;
            IEditorInput editorInput = dEditor.getEditorInput();
            IFile file = (IFile)editorInput.getAdapter(IFile.class);
            if (file != null) {
                diagramName = file.getFullPath().toOSString();
            } else {
                diagramName = dEditor.getPartName();
                if (diagramName == null) {
                    diagramName = dEditor.getTitle();
                }
            }
            if (diagramName == null) {
                diagramName = dEditor.getDiagram().getName();
            }
            diagramMap.put(diagramName, dEditor.getDiagram());
        }
        return diagramMap;
    }
}

