/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.preview;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.jsp.el.ELException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.jsf.common.ui.internal.utils.ResourceUtils;
import org.eclipse.jst.jsf.core.internal.tld.LoadBundleUtil;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.jsp.core.pagevar.IPageVariablesProvider;
import org.eclipse.jst.pagedesigner.jsp.core.pagevar.IVariableInfo;
import org.eclipse.jst.pagedesigner.preview.IELValueResolver;
import org.w3c.dom.Element;

public class PageExpressionContext {
    private static final Logger _log = PDPlugin.getLogger(PageExpressionContext.class);
    static PageExpressionContext _current;
    List _pageVarProviders = new ArrayList();
    private IProject _prj;

    public PageExpressionContext(IProject prj) {
        this._prj = prj;
    }

    public static void reset() {
        _current = null;
    }

    public static void initialize(IProject prj) {
        _current = new PageExpressionContext(prj);
    }

    public static PageExpressionContext getCurrent() {
        return _current;
    }

    public void pushPageVarProvider(IPageVariablesProvider provider) {
        this._pageVarProviders.add(provider);
    }

    public void popPageVarProvider(IPageVariablesProvider provider) {
        try {
            this._pageVarProviders.remove(this._pageVarProviders.size() - 1);
        }
        catch (Exception ex) {
            _log.info("PageExpressionContext.Info.0", (Throwable)ex);
        }
    }

    public Object evaluateExpression(String expression, Class expectedClass, Map options) throws ELException {
        Object objElement;
        String ret = expression;
        if (options != null && (objElement = options.get("ELEMENT")) instanceof Element) {
            ret = ELValueResolver.resolve((Element)objElement, expression);
        }
        return ret;
    }

    public Object getPageVariable(String varName) {
        Properties ret = null;
        int k = this._pageVarProviders.size() - 1;
        while (k >= 0) {
            IVariableInfo[] vars;
            IPageVariablesProvider _pageVars = (IPageVariablesProvider)this._pageVarProviders.get(k);
            if (_pageVars != null && (vars = _pageVars.getBeanInfos()) != null) {
                int i = 0;
                while (i < vars.length) {
                    block12: {
                        if (varName.equals(vars[i].getName()) && vars[i].getMode() == 3) {
                            String resourceName = vars[i].getTypeInfoString();
                            IStorage storage = null;
                            try {
                                storage = LoadBundleUtil.getLoadBundleResource((IProject)this._prj, (String)resourceName);
                            }
                            catch (CoreException cex) {
                                _log.info("PageExpressionContext.Info.0", (Throwable)cex);
                            }
                            if (storage != null) {
                                BufferedInputStream input = null;
                                try {
                                    try {
                                        input = new BufferedInputStream(storage.getContents());
                                        Properties properties = new Properties();
                                        properties.load(input);
                                        ret = properties;
                                    }
                                    catch (Exception exception) {
                                        ResourceUtils.ensureClosed(input);
                                        break block12;
                                    }
                                }
                                catch (Throwable throwable) {
                                    ResourceUtils.ensureClosed(input);
                                    throw throwable;
                                }
                                ResourceUtils.ensureClosed((InputStream)input);
                            }
                        }
                    }
                    ++i;
                }
            }
            --k;
        }
        return ret;
    }

    static class ELValueResolver {
        static List<IELValueResolver> elValueResolvers;

        ELValueResolver() {
        }

        public static String resolve(Element element, String elExpression) {
            String value = elExpression;
            if (elValueResolvers == null) {
                ELValueResolver.readELValueResolvers();
            }
            for (IELValueResolver elValueResolver : elValueResolvers) {
                value = elValueResolver.resolve(element, value);
            }
            return value;
        }

        private static void readELValueResolvers() {
            IExtension[] extensions;
            elValueResolvers = new ArrayList<IELValueResolver>();
            IExtensionPoint pdExtPt = Platform.getExtensionRegistry().getExtensionPoint(PDPlugin.getPluginId(), "pageDesignerExtension");
            IExtension[] iExtensionArray = extensions = pdExtPt.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    if (configElement.getName().equals("elValueResolver")) {
                        try {
                            Object objValueResolver = configElement.createExecutableExtension("class");
                            if (objValueResolver instanceof IELValueResolver) {
                                if (configElement.getContributor().getName().startsWith("org.eclipse.jst")) {
                                    elValueResolvers.add((IELValueResolver)objValueResolver);
                                } else {
                                    elValueResolvers.add(0, (IELValueResolver)objValueResolver);
                                }
                            }
                        }
                        catch (CoreException ce) {
                            PDPlugin.log("Error reading extensions for: " + configElement.toString(), ce);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }
}

