/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.preview.adapter.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.server.core.RuntimeClasspathProviderDelegate;
import org.eclipse.jst.server.preview.adapter.internal.core.PreviewRuntime;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class PreviewRuntimeClasspathProvider
extends RuntimeClasspathProviderDelegate {
    private static final String[] REQUIRED_BUNDLE_IDS = new String[]{PreviewRuntimeClasspathProvider.getBundleForClass(ServletContext.class), PreviewRuntimeClasspathProvider.getBundleForClass(JspContext.class)};

    private static String getBundleForClass(Class<?> cls) {
        Bundle bundle = FrameworkUtil.getBundle(cls);
        return bundle.getSymbolicName() + ":" + bundle.getVersion().toString();
    }

    private String getJavadocLocation(IProject project) {
        int eeVersion = 8;
        try {
            IProjectFacet webModuleFacet;
            IFacetedProject faceted = ProjectFacetsManager.create((IProject)project);
            if (faceted != null && ProjectFacetsManager.isProjectFacetDefined((String)"jst.web") && faceted.hasProjectFacet(webModuleFacet = ProjectFacetsManager.getProjectFacet((String)"jst.web"))) {
                String servletVersionStr = faceted.getInstalledVersion(webModuleFacet).getVersionString();
                if (servletVersionStr.equals("6.1")) {
                    eeVersion = 11;
                } else if (servletVersionStr.equals("6.0")) {
                    eeVersion = 10;
                } else if (servletVersionStr.equals("5.0")) {
                    eeVersion = 9;
                } else if (servletVersionStr.equals("4.0")) {
                    eeVersion = 8;
                } else if (servletVersionStr.equals("3.1")) {
                    eeVersion = 7;
                } else if (servletVersionStr.equals("3.0")) {
                    eeVersion = 6;
                } else if (servletVersionStr.equals("2.5")) {
                    eeVersion = 5;
                } else if (servletVersionStr.equals("2.4")) {
                    eeVersion = 4;
                } else if (servletVersionStr.equals("2.3")) {
                    eeVersion = 3;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (CoreException coreException) {}
        String url = "https://jakarta.ee/specifications/servlet/6.0/apidocs/";
        switch (eeVersion) {
            case 3: {
                url = "https://docs.oracle.com/javaee/3/api/";
                break;
            }
            case 4: {
                url = "https://docs.oracle.com/javaee/4/api/";
                break;
            }
            case 5: {
                url = "https://docs.oracle.com/javaee/5/api/";
                break;
            }
            case 6: {
                url = "https://docs.oracle.com/javaee/6/api/";
                break;
            }
            case 7: {
                url = "https://docs.oracle.com/javaee/7/api/";
                break;
            }
            case 8: {
                url = "https://javaee.github.io/javaee-spec/javadocs/";
                break;
            }
            case 9: {
                url = "https://jakarta.ee/specifications/servlet/5.0/apidocs/";
                break;
            }
            case 10: {
                url = "https://jakarta.ee/specifications/servlet/6.0/apidocs/";
                break;
            }
            case 11: {
                url = "https://jakarta.ee/specifications/servlet/6.1/apidocs/";
                break;
            }
            default: {
                url = "https://jakarta.ee/specifications/servlet/6.0/apidocs/";
            }
        }
        return url;
    }

    public IClasspathEntry[] resolveClasspathContainer(IProject project, IRuntime runtime) {
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        String docUrl = this.getJavadocLocation(project);
        int size = REQUIRED_BUNDLE_IDS.length;
        int i = 0;
        while (i < size) {
            String[] bundleInfo = REQUIRED_BUNDLE_IDS[i].split(":");
            String version = null;
            if (bundleInfo.length > 1) {
                version = bundleInfo[1];
            }
            Bundle[] bundles = Platform.getBundles((String)bundleInfo[0], (String)version);
            Arrays.sort(bundles, (bundle1, bundle2) -> bundle1.getVersion().compareTo(bundle2.getVersion()));
            Bundle b = bundles[0];
            IPath path = PreviewRuntime.getJarredPluginPath(b);
            if (path != null) {
                IClasspathEntry libraryEntry = JavaCore.newLibraryEntry((IPath)path, null, null, (IAccessRule[])new IAccessRule[0], (IClasspathAttribute[])new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"javadoc_location", (String)docUrl)}, (boolean)false);
                list.add(libraryEntry);
            }
            ++i;
        }
        return list.toArray(new IClasspathEntry[list.size()]);
    }
}

