/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxrs.core.internal.project.facet;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.ws.jaxrs.core.internal.JAXRSCorePlugin;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrslibraryproviderconfig.JAXRSLibraryProviderUtil;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public abstract class JAXRSUtils {
    public static final String JAXRS_DEFAULT_SERVLET_NAME = "JAX-RS Servlet";
    public static final String JAXRS_SERVLET_CLASS = "";
    public static final String JAXRS_DEFAULT_URL_MAPPING = "/jaxrs/*";
    public static final String PP_JAXRS_IMPLEMENTATION_LIBRARIES = "jaxrs.implementation.libraries";
    public static final String JAXRS_SERVLET_IDENTIFIER = "JAX-RS Tools Generated";
    public static final String JAXRS_SERVLET_IDENTIFIER_DESCRIPTION = "JAX-RS Tools Generated - Do not modify";

    protected static String getDisplayName(IDataModel config) {
        String displayName = config.getStringProperty("IJAXRSFacetInstallDataModelProperties.SERVLET_NAME");
        if (displayName == null || displayName.trim().equals(JAXRS_SERVLET_CLASS)) {
            displayName = JAXRS_DEFAULT_SERVLET_NAME;
        }
        return displayName.trim();
    }

    protected static String getServletClassname(IDataModel config) {
        String className = config.getStringProperty("IJAXRSFacetInstallDataModelProperties.SERVLET_CLASSNAME");
        if (className == null || className.trim().equals(JAXRS_SERVLET_CLASS)) {
            className = JAXRS_SERVLET_CLASS;
        }
        return className.trim();
    }

    public static IModelProvider getModelProvider(IProject webProject) {
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)webProject);
        Object webAppObj = provider.getModelObject();
        if (webAppObj == null) {
            return null;
        }
        return provider;
    }

    static String getSavedServletClassName(String libraryProviderID) {
        String JAXRSUISettingsRoot;
        IDialogSettings root;
        IDialogSettings jaxrsUISettings = JAXRSCorePlugin.getDefault().getJaxrsUISettings();
        if (jaxrsUISettings != null && (root = jaxrsUISettings.getSection(JAXRSUISettingsRoot = "org.eclipse.jst.ws.jaxrs.ui.jaxrsFacetInstall")) != null) {
            String toReturn = root.get(libraryProviderID + "servletClassname");
            if (toReturn == null) {
                toReturn = root.get("servletClassname");
            }
            return toReturn;
        }
        return null;
    }

    static boolean facetKnowsServletClassName(String servletClassName) {
        return JAXRSLibraryProviderUtil.servletClassNameHasLibraryProvider(servletClassName);
    }

    static String getSavedServletName() {
        String JAXRSUISettingsRoot;
        IDialogSettings root;
        IDialogSettings jaxrsUISettings = JAXRSCorePlugin.getDefault().getJaxrsUISettings();
        if (jaxrsUISettings != null && (root = jaxrsUISettings.getSection(JAXRSUISettingsRoot = "org.eclipse.jst.ws.jaxrs.ui.jaxrsFacetInstall")) != null) {
            return root.get("servletClassname");
        }
        return null;
    }

    static String getSavedservletName() {
        String JAXRSUISettingsRoot;
        IDialogSettings root;
        IDialogSettings jaxrsUISettings = JAXRSCorePlugin.getDefault().getJaxrsUISettings();
        if (jaxrsUISettings != null && (root = jaxrsUISettings.getSection(JAXRSUISettingsRoot = "org.eclipse.jst.ws.jaxrs.ui.jaxrsFacetInstall")) != null) {
            return root.get("servletName");
        }
        return null;
    }

    public static class MappingSearchResult {
        private final String _extensionMapping;
        private final String _prefixMapping;

        MappingSearchResult(String extensionMapping, String prefixMapping) {
            this._extensionMapping = extensionMapping;
            this._prefixMapping = prefixMapping;
        }

        public boolean isResult() {
            return this._extensionMapping != null || this._prefixMapping != null;
        }

        public final String getExtensionMapping() {
            return this._extensionMapping;
        }

        public final String getPrefixMapping() {
            return this._prefixMapping;
        }
    }
}

