/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.cachegrind.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.linuxtools.internal.valgrind.cachegrind.model.CachegrindFunction;
import org.eclipse.linuxtools.internal.valgrind.cachegrind.model.CachegrindOutput;
import org.eclipse.linuxtools.internal.valgrind.cachegrind.model.ICachegrindElement;

public class CachegrindFile
implements ICachegrindElement {
    private static final String UNKNOWN_FILE = "???";
    private CachegrindOutput parent;
    private String path;
    private List<CachegrindFunction> functions;
    private IAdaptable model;

    public CachegrindFile(CachegrindOutput parent, String path) {
        this.parent = parent;
        this.path = path;
        this.functions = new ArrayList<CachegrindFunction>();
        IPath pathObj = Path.fromOSString((String)path);
        if (path.equals(UNKNOWN_FILE)) {
            this.model = null;
        } else {
            this.model = CoreModel.getDefault().create(pathObj);
            if (this.model == null) {
                this.model = ResourcesPlugin.getWorkspace().getRoot().getFile(pathObj);
            }
        }
    }

    public void addFunction(CachegrindFunction func) {
        this.functions.add(func);
    }

    public CachegrindFunction[] getFunctions() {
        return this.functions.toArray(new CachegrindFunction[this.functions.size()]);
    }

    @Override
    public ICachegrindElement[] getChildren() {
        return this.getFunctions();
    }

    @Override
    public IAdaptable getModel() {
        return this.model;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        String name = this.path;
        if (Path.ROOT.isValidPath(this.path)) {
            name = Path.fromOSString((String)this.path).lastSegment();
        }
        return name;
    }

    @Override
    public ICachegrindElement getParent() {
        return this.parent;
    }

    @Override
    public int compareTo(ICachegrindElement o) {
        int result = 0;
        if (o instanceof CachegrindFile) {
            result = this.getName().compareTo(((CachegrindFile)o).getName());
        }
        return result;
    }
}

