/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.editors;

import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.modisco.infra.browser.core.InstancesForMetaclasses;
import org.eclipse.modisco.infra.browser.core.ItemsFactoryEx;
import org.eclipse.modisco.infra.browser.editors.EcoreBrowser;
import org.eclipse.modisco.infra.browser.queries.SelectedQueriesManager;
import org.eclipse.modisco.infra.browser.uicore.ChangeListener;
import org.eclipse.modisco.infra.browser.uicore.internal.AppearanceConfiguration;
import org.eclipse.modisco.infra.browser.uicore.internal.model.ItemsFactory;
import org.eclipse.swt.widgets.Display;

public class BrowserConfiguration {
    public static final int NOT_YET_ASKED = -2;
    private ResourceSet resourceSet;
    private InstancesForMetaclasses instancesForMetaclasses;
    private EcoreBrowser editor;
    private SelectedQueriesManager selectedQueriesManager;
    private int referencedResourcesLoadingDepth = -2;
    private final AppearanceConfiguration appearanceConfiguration;
    private Set<Resource> browsedResources;

    public BrowserConfiguration(EcoreBrowser editor) {
        this();
        this.editor = editor;
    }

    public BrowserConfiguration() {
        ItemsFactoryEx itemsFactory = new ItemsFactoryEx(this);
        this.appearanceConfiguration = new AppearanceConfiguration((ItemsFactory)itemsFactory);
    }

    public EcoreBrowser getEditor() {
        return this.editor;
    }

    public AppearanceConfiguration getAppearanceConfiguration() {
        return this.appearanceConfiguration;
    }

    public void setResourceSet(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public void setInstancesForMetaclasses(InstancesForMetaclasses instancesForMetaclasses) {
        this.instancesForMetaclasses = instancesForMetaclasses;
    }

    public InstancesForMetaclasses getInstancesForMetaclasses() {
        return this.instancesForMetaclasses;
    }

    public void dispose() {
        this.editor = null;
    }

    public String getMetamodelName() {
        String[] parts;
        String nsURI = this.getMetamodelURI();
        if (nsURI != null && (parts = nsURI.split("/")).length > 0) {
            return parts[parts.length - 1];
        }
        return null;
    }

    public String getMetamodelURI() {
        EPackage ePackage;
        EObject firstElement;
        EClass eClass;
        Resource firstResource;
        EList contents;
        EList resources = this.resourceSet.getResources();
        if (resources.size() > 0 && (contents = (firstResource = (Resource)resources.get(0)).getContents()).size() > 0 && (eClass = (firstElement = (EObject)contents.get(0)).eClass()) != null && (ePackage = eClass.getEPackage()) != null) {
            return ePackage.getNsURI();
        }
        return null;
    }

    public void setSelectedQueriesManager(SelectedQueriesManager selectedQueriesManager) {
        this.selectedQueriesManager = selectedQueriesManager;
        this.getAppearanceConfiguration().touch();
        this.selectedQueriesManager.addChangeListener(new ChangeListener(){

            public void changed() {
                BrowserConfiguration.this.getAppearanceConfiguration().touch();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).BrowserConfiguration.this.editor.refreshDelayed(false);
                    }
                });
            }
        });
    }

    public SelectedQueriesManager getSelectedQueriesManager() {
        return this.selectedQueriesManager;
    }

    public void setBrowsedResources(Set<Resource> browsedResources) {
        this.browsedResources = browsedResources;
        this.getAppearanceConfiguration().touch();
    }

    public Set<Resource> getBrowsedResources() {
        if (this.browsedResources != null) {
            return Collections.unmodifiableSet(this.browsedResources);
        }
        return null;
    }

    public void addBrowsedResource(Resource resource) {
        this.browsedResources.add(resource);
        this.getAppearanceConfiguration().touch();
    }

    public void removeBrowsedResource(Resource resource) {
        this.browsedResources.remove(resource);
        this.getAppearanceConfiguration().touch();
    }

    public void setReferencedResourcesLoadingDepth(int referencedResourcesLoadingDepth) {
        this.referencedResourcesLoadingDepth = referencedResourcesLoadingDepth;
        this.getAppearanceConfiguration().touch();
    }

    public int getReferencedResourcesLoadingDepth() {
        return this.referencedResourcesLoadingDepth;
    }
}

