/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.eventmanager;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public class NotificationHelper {
    public static boolean isAttributeValueChangeEvent(Notification n) {
        boolean result = false;
        EStructuralFeature feature = NotificationHelper.getNotificationFeature(n);
        if (feature != null) {
            result = feature instanceof EAttribute;
        }
        return result;
    }

    public static boolean isLinkLifeCycleEvent(Notification n) {
        boolean result = false;
        EStructuralFeature feature = NotificationHelper.getNotificationFeature(n);
        if (feature != null) {
            result = feature instanceof EReference;
        }
        return result;
    }

    public static boolean isElementLifeCycleEvent(Notification n) {
        if (n.getFeature() != null && n.getFeature() instanceof EReference) {
            return ((EReference)n.getFeature()).isContainment();
        }
        return n.getFeature() == null && n.getNotifier() instanceof Resource;
    }

    public static EStructuralFeature getNotificationFeature(Notification n) {
        return n.getFeature() == null ? null : (EStructuralFeature)n.getFeature();
    }

    public static boolean isManyEvent(Notification event) {
        switch (event.getEventType()) {
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public static boolean isAddEvent(Notification event) {
        switch (event.getEventType()) {
            case 3: 
            case 5: {
                return true;
            }
            case 1: {
                return event.getNewValue() != null;
            }
        }
        return false;
    }
}

