/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.version;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.oomph.internal.version.BuildState;
import org.eclipse.oomph.util.IOUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.oomph.version";
    private static final String BUILD_STATES = "buildStates.bin";
    private static Activator plugin;
    private static IResourceChangeListener postBuildListener;
    private static BuildStates buildStates;
    private static final String PREFERENCE_NODE = "/instance/org.eclipse.oomph.version";

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        try {
            try {
                buildStates = (BuildStates)Activator.load(BUILD_STATES);
            }
            catch (Throwable throwable) {
                File stateFile = Activator.getStateFile(BUILD_STATES);
                if (stateFile.exists()) {
                    stateFile.delete();
                }
                if (buildStates == null) {
                    buildStates = new BuildStates();
                }
            }
        }
        finally {
            File stateFile = Activator.getStateFile(BUILD_STATES);
            if (stateFile.exists()) {
                stateFile.delete();
            }
            if (buildStates == null) {
                buildStates = new BuildStates();
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (postBuildListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(postBuildListener);
            postBuildListener = null;
        }
        if (!buildStates.isEmpty()) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            Iterator it = buildStates.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String projectName = (String)entry.getKey();
                IProject project = root.getProject(projectName);
                if (!project.exists()) {
                    it.remove();
                    continue;
                }
                BuildState buildState = (BuildState)entry.getValue();
                buildState.serializeValidatorState();
            }
            Activator.save(BUILD_STATES, buildStates);
        }
        buildStates = null;
        plugin = null;
        super.stop(context);
    }

    public static void setPostBuildListener(IResourceChangeListener postBuildListener) {
        Activator.postBuildListener = postBuildListener;
    }

    public static Set<String> getReleasePaths() {
        IEclipsePreferences root = Platform.getPreferencesService().getRootNode();
        try {
            if (root.nodeExists(PREFERENCE_NODE)) {
                Preferences node = root.node(PREFERENCE_NODE);
                return new HashSet<String>(Arrays.asList(node.keys()));
            }
        }
        catch (BackingStoreException ex) {
            Activator.log(ex);
        }
        return Collections.emptySet();
    }

    public static ReleaseCheckMode getReleaseCheckMode(String releasePath) {
        IEclipsePreferences root = Platform.getPreferencesService().getRootNode();
        try {
            Preferences node;
            String value;
            if (root.nodeExists(PREFERENCE_NODE) && (value = (node = root.node(PREFERENCE_NODE)).get(releasePath, null)) != null) {
                return ReleaseCheckMode.valueOf(value);
            }
        }
        catch (BackingStoreException ex) {
            Activator.log(ex);
        }
        return null;
    }

    public static void setReleaseCheckMode(String releasePath, ReleaseCheckMode releaseCheckMode) {
        IEclipsePreferences root = Platform.getPreferencesService().getRootNode();
        Preferences node = root.node(PREFERENCE_NODE);
        node.put(releasePath, releaseCheckMode.toString());
        try {
            node.flush();
        }
        catch (BackingStoreException ex) {
            Activator.log(ex);
        }
    }

    public static LaxLowerBoundCheckMode getLaxLowerBoundCheckMode(String releasePath) {
        IEclipsePreferences root = Platform.getPreferencesService().getRootNode();
        try {
            Preferences node;
            String value;
            if (root.nodeExists(PREFERENCE_NODE) && (value = (node = root.node("/instance/org.eclipse.oomph.version/laxLowerBound")).get(releasePath, null)) != null) {
                return LaxLowerBoundCheckMode.valueOf(value);
            }
        }
        catch (BackingStoreException ex) {
            Activator.log(ex);
        }
        return null;
    }

    public static void setLaxLowerBoundCheckMode(String releasePath, LaxLowerBoundCheckMode laxLowerBoundCheckMode) {
        IEclipsePreferences root = Platform.getPreferencesService().getRootNode();
        Preferences node = root.node("/instance/org.eclipse.oomph.version/laxLowerBound");
        node.put(releasePath, laxLowerBoundCheckMode.toString());
        try {
            node.flush();
        }
        catch (BackingStoreException ex) {
            Activator.log(ex);
        }
    }

    public static BuildState getBuildState(IProject project) {
        String name = project.getName();
        BuildState buildState = (BuildState)buildStates.get(name);
        if (buildState == null) {
            buildState = new BuildState();
            buildStates.put(name, buildState);
        }
        return buildState;
    }

    public static void clearBuildState(IProject project) {
        String name = project.getName();
        buildStates.remove(name);
    }

    public static void log(String message) {
        plugin.getLog().log((IStatus)new Status(1, PLUGIN_ID, message));
    }

    public static void log(IStatus status) {
        plugin.getLog().log(status);
    }

    public static void log(Throwable t, int severity) {
        Activator.log(Activator.getStatus(t, severity));
    }

    public static String log(Throwable t) {
        IStatus status = Activator.getStatus(t);
        Activator.log(status);
        return status.getMessage();
    }

    public static IStatus getStatus(Throwable t) {
        if (t instanceof CoreException) {
            CoreException coreException = (CoreException)t;
            return coreException.getStatus();
        }
        String msg = t.getLocalizedMessage();
        if (msg == null || msg.length() == 0) {
            msg = t.getClass().getName();
        }
        return new Status(4, PLUGIN_ID, msg, t);
    }

    public static IStatus getStatus(Throwable t, int severity) {
        String msg = t.getLocalizedMessage();
        if (msg == null || msg.length() == 0) {
            msg = t.getClass().getName();
        }
        return new Status(severity, PLUGIN_ID, msg, t);
    }

    private static File getStateFile(String name) {
        File stateFolder = Platform.getStateLocation((Bundle)plugin.getBundle()).toFile();
        return new File(stateFolder, name);
    }

    private static <T> T load(String fileName) throws IOException, ClassNotFoundException {
        Object object;
        ObjectInputStream stream = null;
        try {
            Object object2;
            File stateFile = Activator.getStateFile(fileName);
            stream = new ObjectInputStream(new FileInputStream(stateFile));
            object = object2 = stream.readObject();
        }
        catch (Throwable throwable) {
            IOUtil.closeSilent(stream);
            throw throwable;
        }
        IOUtil.closeSilent((Closeable)stream);
        return (T)object;
    }

    private static void save(String fileName, Object object) {
        block5: {
            ObjectOutputStream stream = null;
            try {
                try {
                    File file = Activator.getStateFile(fileName);
                    stream = new ObjectOutputStream(new FileOutputStream(file));
                    stream.writeObject(object);
                }
                catch (Throwable ex) {
                    Activator.log(ex);
                    IOUtil.closeSilent(stream);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeSilent(stream);
                throw throwable;
            }
            IOUtil.closeSilent((Closeable)stream);
        }
    }

    private static final class BuildStates
    extends HashMap<String, BuildState> {
        private static final long serialVersionUID = 2L;
    }

    public static enum LaxLowerBoundCheckMode {
        SAME_RELEASE,
        ANY_RELEASE,
        ALL;

    }

    public static enum ReleaseCheckMode {
        NONE,
        PARTIAL,
        FULL;

    }
}

