/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.builders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.builders.BuildErrorReporter;
import org.eclipse.pde.internal.core.project.PDEProject;

public class SourceEntryErrorReporter
extends BuildErrorReporter {
    private static final String DEF_OUTPUT_ENTRY = "output..";
    private final Map<IPath, SourceFolder> fSourceFolderMap = new HashMap<IPath, SourceFolder>(4);
    private final Map<IPath, OutputFolder> fOutputFolderMap = new HashMap<IPath, OutputFolder>(4);
    private IBuild fBuild = null;

    public SourceEntryErrorReporter(IFile file, IBuild model) {
        super(file);
        this.fBuild = model;
    }

    public void initialize(List<IBuildEntry> sourceEntries, List<IBuildEntry> outputEntries, IClasspathEntry[] cpes) {
        IPath path;
        String token;
        String[] tokens;
        String msg;
        int n;
        IPath defaultOutputLocation = null;
        IJavaProject javaProject = JavaCore.create((IProject)this.fProject);
        try {
            defaultOutputLocation = javaProject.getOutputLocation();
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        HashSet<String> pluginLibraryNames = new HashSet<String>(2);
        IPluginModelBase pluginModel = PluginRegistry.findModel(this.fProject);
        if (pluginModel != null) {
            IPluginLibrary[] pluginLibraries = pluginModel.getPluginBase().getLibraries();
            IPluginObject[] iPluginObjectArray = pluginLibraries;
            int n2 = pluginLibraries.length;
            n = 0;
            while (n < n2) {
                IPluginLibrary library = iPluginObjectArray[n];
                pluginLibraryNames.add(library.getName());
                ++n;
            }
            iPluginObjectArray = pluginModel.getPluginBase().getExtensions();
            n2 = iPluginObjectArray.length;
            n = 0;
            while (n < n2) {
                IPluginObject extension = iPluginObjectArray[n];
                if ("org.eclipse.ant.core.extraClasspathEntries".equals(extension.getPoint())) {
                    IPluginObject[] iPluginObjectArray2 = extension.getChildren();
                    int n3 = iPluginObjectArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPluginElement element;
                        IPluginAttribute library;
                        IPluginObject pluginObject = iPluginObjectArray2[n4];
                        if ("extraClasspathEntry".equals(pluginObject.getName()) && pluginObject instanceof IPluginElement && (library = (element = (IPluginElement)pluginObject).getAttribute("library")) != null) {
                            pluginLibraryNames.add(library.getValue().trim());
                        }
                        ++n4;
                    }
                }
                ++n;
            }
        }
        pluginLibraryNames.add(".");
        IClasspathEntry[] iClasspathEntryArray = cpes;
        n = cpes.length;
        int n5 = 0;
        while (n5 < n) {
            IPackageFragmentRoot[] roots;
            IClasspathEntry entry = iClasspathEntryArray[n5];
            if (entry.getEntryKind() == 3) {
                IPath sourcePath = this.getPath(entry);
                if (sourcePath != null) {
                    IPath outputLocation = entry.getOutputLocation();
                    if (outputLocation == null) {
                        outputLocation = defaultOutputLocation;
                    }
                    IPath outputPath = this.getPath(outputLocation);
                    OutputFolder outputFolder = this.fOutputFolderMap.computeIfAbsent(outputPath, OutputFolder::new);
                    SourceFolder sourceFolder = this.fSourceFolderMap.computeIfAbsent(sourcePath, p -> new SourceFolder((IPath)p, outputFolder));
                    outputFolder.addSourceFolder(sourceFolder);
                }
            } else if (entry.getEntryKind() == 1 && (roots = javaProject.findPackageFragmentRoots(entry)).length == 1 && !roots[0].isArchive()) {
                IPath outputPath = this.getPath(entry);
                OutputFolder outputFolder = new OutputFolder(outputPath, true);
                this.fOutputFolderMap.put(outputPath, outputFolder);
            }
            ++n5;
        }
        for (IBuildEntry sourceEntry : sourceEntries) {
            String libName = sourceEntry.getName().substring("source.".length());
            if (!pluginLibraryNames.contains(libName)) {
                msg = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_MissingLibrary, (Object)libName);
                this.prepareSourceError(sourceEntry.getName(), null, msg, 8197);
            }
            String[] stringArray = tokens = sourceEntry.getTokens();
            int n6 = tokens.length;
            int n7 = 0;
            while (n7 < n6) {
                token = stringArray[n7];
                path = IPath.fromOSString((String)token).addTrailingSeparator();
                SourceFolder sourceFolder = this.fSourceFolderMap.computeIfAbsent(path, p -> new SourceFolder((IPath)p, null));
                sourceFolder.setToken(token);
                sourceFolder.addLib(libName);
                ++n7;
            }
        }
        for (IBuildEntry outputEntry : outputEntries) {
            String libName = outputEntry.getName().substring("output.".length());
            if (!pluginLibraryNames.contains(libName)) {
                msg = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_MissingLibrary, (Object)libName);
                this.prepareOutputError(outputEntry.getName(), null, msg, 8197);
            }
            String[] stringArray = tokens = outputEntry.getTokens();
            int n8 = tokens.length;
            int n9 = 0;
            while (n9 < n8) {
                token = stringArray[n9];
                path = IPath.fromOSString((String)token).addTrailingSeparator();
                if (path.segmentCount() == 1 && path.segment(0).equals(".")) {
                    path = IPath.ROOT;
                }
                OutputFolder outputFolder = this.fOutputFolderMap.computeIfAbsent(path, OutputFolder::new);
                outputFolder.setToken(token);
                outputFolder.addLib(libName);
                ++n9;
            }
        }
    }

    private IPath getPath(Object entry) {
        IPath path = null;
        if (entry instanceof IClasspathEntry) {
            IClasspathEntry cpes = (IClasspathEntry)entry;
            path = cpes.getPath();
        } else if (entry instanceof IPath) {
            IPath entryPath;
            path = entryPath = (IPath)entry;
        }
        if (path != null && path.matchingFirstSegments(this.fProject.getFullPath()) > 0) {
            path = path.removeFirstSegments(1);
        }
        if (path != null) {
            return path.addTrailingSeparator();
        }
        return null;
    }

    public void validate() {
        this.validateOutputEntries();
        List<SourceFolder> toValidate = this.validateSourceEntries();
        this.validateSourceEncodings(toValidate);
    }

    private void validateOutputEntries() {
        this.fOutputFolderMap.forEach((outputPath, outputFolder) -> {
            List<SourceFolder> sourceFolders = outputFolder.getSourceFolders();
            ArrayList<String> outputFolderLibs = new ArrayList<String>(outputFolder.getLibs());
            if (sourceFolders.isEmpty()) {
                IPluginModelBase model;
                if (!outputFolder.isLibrary()) {
                    for (String libName : outputFolderLibs) {
                        IResource folderEntry = this.fProject.findMember(outputPath);
                        String message = folderEntry == null || !folderEntry.exists() || !(folderEntry instanceof IContainer) ? NLS.bind((String)PDECoreMessages.BuildErrorReporter_missingFolder, (Object)outputPath.toString()) : NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_InvalidOutputFolder, (Object)outputPath.toString());
                        this.prepareOutputError("output." + libName, outputFolder.getToken(), message, 8197);
                    }
                } else if (outputFolderLibs.isEmpty() && (model = PluginRegistry.findModel(this.fProject)) != null) {
                    IPluginLibrary[] libs = model.getPluginBase().getLibraries();
                    String message = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_MissingOutputLibForClassFolder, (Object)outputPath.toString());
                    if (libs.length > 0) {
                        this.prepareOutputError("output.", null, message, 4135);
                    } else {
                        this.prepareOutputError(DEF_OUTPUT_ENTRY, outputPath.toString(), message, 8195);
                    }
                }
            } else {
                String srcFolderLibName = null;
                block5: for (SourceFolder sourceFolder : sourceFolders) {
                    List<String> srcFolderLibs = sourceFolder.getLibs();
                    outputFolderLibs.removeAll(srcFolderLibs);
                    switch (srcFolderLibs.size()) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            if (srcFolderLibName == null) {
                                srcFolderLibName = srcFolderLibs.get(0);
                                break;
                            }
                            if (srcFolderLibName.equals(srcFolderLibs.get(0))) continue block5;
                        }
                        default: {
                            String erringSrcFolders = sourceFolders.stream().map(f -> f.getPath().toString().trim()).filter(s -> !s.isEmpty()).collect(Collectors.joining(","));
                            for (SourceFolder srcFolder : sourceFolders) {
                                for (String libName : srcFolder.getLibs()) {
                                    String message = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_DifferentTargetLibrary, (Object)erringSrcFolders);
                                    this.prepareSourceError("source." + libName, srcFolder.getToken(), message, 4135);
                                }
                            }
                            continue block5;
                        }
                    }
                }
                for (String outputFolderLib : outputFolderLibs) {
                    String message = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_ExtraOutputFolder, (Object)outputFolder.getPath().toString(), (Object)("source." + outputFolderLib));
                    this.prepareOutputError("output." + outputFolderLib, outputFolder.getToken(), message, 8197);
                }
                if (outputFolder.getDupeLibName() != null) {
                    String message = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_DupeOutputFolder, (Object)outputPath.toString(), (Object)("output." + outputFolder.getDupeLibName()));
                    this.prepareOutputError("output." + outputFolder.getDupeLibName(), outputFolder.getToken(), message, 4135);
                }
            }
        });
    }

    private List<SourceFolder> validateSourceEntries() {
        record MissingOutputEntry(Set<String> fSrcFolders, Set<String> fOutputFolders) {
        }
        HashMap<String, MissingOutputEntry> missingOutputEntryErrors = new HashMap<String, MissingOutputEntry>(4);
        ArrayList<SourceFolder> toValidate = new ArrayList<SourceFolder>();
        this.fSourceFolderMap.forEach((sourcePath, sourceFolder) -> {
            OutputFolder outputFolder = sourceFolder.getOutputLocation();
            if (outputFolder == null) {
                IResource folderEntry = this.fProject.findMember(sourcePath);
                String message = folderEntry == null || !folderEntry.exists() || !(folderEntry instanceof IContainer) ? NLS.bind((String)PDECoreMessages.BuildErrorReporter_missingFolder, (Object)sourcePath.toString()) : NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_InvalidSourceFolder, (Object)sourcePath.toString());
                for (String libName : sourceFolder.getLibs()) {
                    this.prepareSourceError("source." + libName, sourceFolder.getToken(), message, 8197);
                }
            } else {
                if (outputFolder.getLibs().isEmpty() && sourceFolder.getLibs().size() == 1) {
                    String libName = sourceFolder.getLibs().get(0);
                    MissingOutputEntry errorEntry = missingOutputEntryErrors.computeIfAbsent(libName, n -> new MissingOutputEntry(new LinkedHashSet<String>(1), new LinkedHashSet<String>(1)));
                    errorEntry.fSrcFolders().add(sourcePath.toString());
                    errorEntry.fOutputFolders().add(outputFolder.getToken());
                }
                if (sourceFolder.getDupeLibName() != null) {
                    String message = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_DupeSourceFolder, (Object)sourcePath.toString(), (Object)("source." + sourceFolder.getDupeLibName()));
                    this.prepareSourceError("source." + sourceFolder.getDupeLibName(), sourceFolder.getToken(), message, 4135);
                }
                toValidate.add((SourceFolder)sourceFolder);
            }
        });
        missingOutputEntryErrors.forEach((libName, errorEntry) -> {
            String sourceList = String.join((CharSequence)", ", errorEntry.fSrcFolders());
            String outputList = String.join((CharSequence)", ", errorEntry.fOutputFolders());
            String message = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_MissingOutputEntry, (Object)sourceList, (Object)("output." + libName));
            this.prepareError("output." + libName, outputList, message, 8195, this.fMissingOutputLibSeverity, "compilers.p.build.missing.output", "");
        });
        return toValidate;
    }

    private void validateSourceEncodings(List<SourceFolder> toValidate) {
        if (this.fEncodingSeverity == 0 || this.fEncodingSeverity == 1 || this.fEncodingSeverity == 3) {
            IBuildEntry[] entries;
            HashMap<String, String> defaultLibraryEncodings = new HashMap<String, String>();
            HashMap<String, List> customEncodings = new HashMap<String, List>();
            for (SourceFolder sourceFolder : toValidate) {
                IPath sourcePath = sourceFolder.getPath();
                IProject container = this.fProject;
                if (!sourcePath.isEmpty() && !sourcePath.isRoot()) {
                    container = container.getFolder(sourcePath);
                }
                try {
                    String encoding = this.getExplicitEncoding((IContainer)container);
                    if (encoding != null) {
                        for (String lib2 : sourceFolder.getLibs()) {
                            defaultLibraryEncodings.put(lib2, encoding);
                        }
                    }
                    container.accept(resource -> {
                        String resourceEncoding;
                        switch (resource.getType()) {
                            case 2: {
                                String string = ((IFolder)resource).getDefaultCharset(false);
                                break;
                            }
                            case 1: {
                                String string;
                                IFile file = (IFile)resource;
                                if ("java".equals(file.getFileExtension())) {
                                    string = file.getCharset(false);
                                    break;
                                }
                                string = null;
                                break;
                            }
                            default: {
                                String string = resourceEncoding = null;
                            }
                        }
                        if (resourceEncoding != null) {
                            EncodingEntry entry = new EncodingEntry(resource, resourceEncoding);
                            for (String lib : sourceFolder.getLibs()) {
                                customEncodings.computeIfAbsent(lib, l -> new ArrayList()).add(entry);
                            }
                        }
                        return true;
                    });
                }
                catch (CoreException e) {
                    PDECore.log(e);
                }
            }
            IBuildEntry[] iBuildEntryArray = entries = this.fBuild.getBuildEntries();
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildEntry entry = iBuildEntryArray[n2];
                String name = entry.getName();
                if (name.startsWith("javacDefaultEncoding.")) {
                    String lib3 = name.substring("javacDefaultEncoding.".length());
                    String[] tokens = entry.getTokens();
                    if (tokens.length > 0) {
                        if (tokens.length == 1) {
                            String specified = tokens[0];
                            String expected2 = (String)defaultLibraryEncodings.remove(lib3);
                            if (expected2 != null) {
                                if (!specified.equals(expected2)) {
                                    msg = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_0, (Object[])new String[]{expected2, specified, lib3});
                                    this.prepareEncodingError(name, expected2, msg, 8198);
                                }
                            } else {
                                msg = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_1, (Object)specified, (Object)lib3);
                                this.prepareEncodingError(name, null, msg, 8197);
                            }
                        } else {
                            defaultLibraryEncodings.remove(lib3);
                            this.prepareEncodingError(name, null, NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_2, (Object)lib3), 4135);
                        }
                    }
                } else if (name.startsWith("javacCustomEncodings.")) {
                    IContainer bundleRoot = PDEProject.getBundleRoot(this.fProject);
                    String lib4 = name.substring("javacCustomEncodings.".length());
                    String[] tokens = entry.getTokens();
                    if (tokens.length > 0) {
                        ArrayList<EncodingEntry> encodings2 = new ArrayList<EncodingEntry>();
                        String[] stringArray = tokens;
                        int n3 = tokens.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String special = stringArray[n4];
                            int index = special.indexOf(91);
                            if (index >= 0 && special.endsWith("]")) {
                                String path = special.substring(0, index);
                                String encoding = special.substring(index + 1, special.length() - 1);
                                IResource member = bundleRoot.findMember(path);
                                if (member == null) {
                                    String msg = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_3, (Object)encoding, (Object)path);
                                    this.prepareEncodingError(name, special, msg, 8197);
                                } else {
                                    encodings2.add(new EncodingEntry(member, encoding));
                                }
                            } else {
                                String message = PDECoreMessages.SourceEntryErrorReporter_4;
                                this.prepareEncodingError(name, special, message, 4135);
                            }
                            ++n4;
                        }
                        List workspace = (List)customEncodings.remove(lib4);
                        if (workspace == null) {
                            String msg = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_5, (Object)lib4);
                            this.prepareEncodingError(name, null, msg, 8197);
                        } else {
                            HashMap<IResource, String> map = new HashMap<IResource, String>();
                            for (EncodingEntry ee : workspace) {
                                map.put(ee.resource(), ee.encoding());
                            }
                            for (EncodingEntry ee : encodings2) {
                                String msg;
                                String specified = ee.encoding();
                                String expected3 = (String)map.remove(ee.resource());
                                if (expected3 == null) {
                                    msg = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_6, (Object)expected3, (Object)ee.resource().getProjectRelativePath());
                                    this.prepareEncodingError(name, ee.toString(), msg, 8197);
                                    continue;
                                }
                                if (specified.equals(expected3)) continue;
                                msg = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_7, (Object[])new String[]{expected3, ee.resource().getProjectRelativePath().toString(), specified});
                                this.prepareEncodingError(name, ee.toString(), msg, 4135);
                            }
                            if (!map.isEmpty()) {
                                map.forEach((res, expected) -> {
                                    String missing = new EncodingEntry((IResource)res, (String)expected).toString();
                                    String msg = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_8, (Object)expected, (Object)res.getProjectRelativePath().toString());
                                    this.prepareEncodingError(name, missing, msg, 8195);
                                });
                            }
                        }
                    }
                }
                ++n2;
            }
            defaultLibraryEncodings.forEach((lib, expected) -> {
                String msg = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_9, (Object)expected, (Object)lib);
                this.prepareEncodingError("javacDefaultEncoding." + lib, (String)expected, msg, 8195);
            });
            customEncodings.forEach((lib, encodings) -> {
                for (EncodingEntry encoding : encodings) {
                    String msg = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_8, (Object)encoding.encoding(), (Object)encoding.resource().getProjectRelativePath());
                    this.prepareEncodingError("javacCustomEncodings." + lib, encoding.toString(), msg, 8195);
                }
            });
        }
    }

    private String getExplicitEncoding(IContainer container) throws CoreException {
        IContainer parent;
        String encoding = container.getDefaultCharset(false);
        if (encoding == null && (parent = container.getParent()) != null) {
            switch (parent.getType()) {
                case 2: {
                    return this.getExplicitEncoding(parent);
                }
                case 4: {
                    return this.getExplicitEncoding(parent);
                }
            }
            return null;
        }
        return encoding;
    }

    private record EncodingEntry(IResource resource, String encoding) {
        @Override
        public String toString() {
            IContainer root = PDEProject.getBundleRoot(this.resource().getProject());
            return String.valueOf(this.resource.getFullPath().makeRelativeTo(root.getFullPath()).makeAbsolute()) + "[" + this.encoding + "]";
        }
    }

    private static class OutputFolder
    extends ProjectFolder {
        private final List<SourceFolder> fSourceFolders = new ArrayList<SourceFolder>();
        private final boolean fIsLibrary;

        public OutputFolder(IPath path) {
            this(path, false);
        }

        public OutputFolder(IPath path, boolean isLibrary) {
            super(path);
            this.fIsLibrary = isLibrary;
        }

        public void addSourceFolder(SourceFolder sourceFolder) {
            if (!this.fSourceFolders.contains(sourceFolder)) {
                this.fSourceFolders.add(sourceFolder);
            }
        }

        public boolean isLibrary() {
            return this.fIsLibrary;
        }

        public List<SourceFolder> getSourceFolders() {
            return this.fSourceFolders;
        }
    }

    private static class ProjectFolder {
        private final IPath fPath;
        private String fToken;
        private final List<String> fLibs = new ArrayList<String>(1);
        private String dupeLibName;

        public ProjectFolder(IPath path) {
            this.fPath = path;
        }

        public IPath getPath() {
            return this.fPath;
        }

        void setToken(String token) {
            this.fToken = token;
        }

        public String getToken() {
            if (this.fToken == null) {
                return this.fPath.toString();
            }
            return this.fToken;
        }

        public void addLib(String libName) {
            if (this.fLibs.contains(libName)) {
                this.dupeLibName = libName;
            } else {
                this.fLibs.add(libName);
            }
        }

        public List<String> getLibs() {
            return this.fLibs;
        }

        public String getDupeLibName() {
            return this.dupeLibName;
        }
    }

    private static class SourceFolder
    extends ProjectFolder {
        private final OutputFolder fOutputFolder;

        public SourceFolder(IPath path, OutputFolder outputFolder) {
            super(path);
            this.fOutputFolder = outputFolder;
        }

        public OutputFolder getOutputLocation() {
            return this.fOutputFolder;
        }
    }
}

