/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.hovers;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.internal.ui.text.hover.AbstractScriptEditorTextHover;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ASTParser;
import org.eclipse.php.core.ast.nodes.ArrayAccess;
import org.eclipse.php.core.ast.nodes.ConstantDeclaration;
import org.eclipse.php.core.ast.nodes.FieldAccess;
import org.eclipse.php.core.ast.nodes.ITypeBinding;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.Include;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.ReflectionVariable;
import org.eclipse.php.core.ast.nodes.Scalar;
import org.eclipse.php.core.ast.nodes.SingleFieldDeclaration;
import org.eclipse.php.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.core.ast.nodes.StaticFieldAccess;
import org.eclipse.php.core.ast.nodes.Variable;
import org.eclipse.php.core.ast.nodes.VariableBase;
import org.eclipse.php.core.ast.visitor.AbstractVisitor;
import org.eclipse.php.core.ast.visitor.Visitor;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.corext.dom.NodeFinder;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionsManager;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionsUtil;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.zend.model.PHPStackFrame;
import org.eclipse.php.internal.debug.core.zend.model.PHPVariable;
import org.eclipse.php.internal.debug.ui.hovers.ExpressionInformationControlCreator;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.php.ui.editor.hover.IHoverMessageDecorator;
import org.eclipse.php.ui.editor.hover.IPHPTextHover;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class PHPDebugTextHover
extends AbstractScriptEditorTextHover
implements IPHPTextHover,
ITextHoverExtension2 {
    private ExpressionsUtil expressionsUtil;

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        Object hoverInfo = this.getHoverInfo2(textViewer, hoverRegion);
        return hoverInfo == null ? null : hoverInfo.toString();
    }

    public IHoverMessageDecorator getMessageDecorator() {
        return null;
    }

    protected IStackFrame getFrame() {
        IAdaptable adaptable = DebugUITools.getDebugContext();
        if (adaptable != null) {
            return (IStackFrame)adaptable.getAdapter(PHPStackFrame.class);
        }
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new ExpressionInformationControlCreator();
    }

    protected PHPDebugTarget getDebugTarget() {
        IAdaptable adaptable = DebugUITools.getDebugContext();
        if (adaptable instanceof PHPStackFrame) {
            PHPStackFrame stackFrame = (PHPStackFrame)adaptable;
            IEditorInput ei = this.getEditor().getEditorInput();
            if (ei instanceof FileEditorInput) {
                FileEditorInput fi = (FileEditorInput)ei;
                String fileInDebug = stackFrame.getSourceName();
                String fileInProject = fi.getFile().getProjectRelativePath().toString();
                if (fileInDebug != null && (fileInDebug.endsWith("/" + fileInProject) || fileInDebug.equals(fileInProject))) {
                    PHPDebugTarget debugTarget = (PHPDebugTarget)stackFrame.getDebugTarget();
                    return debugTarget;
                }
            } else {
                PHPDebugTarget debugTarget = (PHPDebugTarget)stackFrame.getDebugTarget();
                return debugTarget;
            }
        }
        return null;
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        PHPVariable variable;
        block38: {
            ASTNode node;
            ISourceModule sourceModule;
            PHPStackFrame frame;
            block37: {
                Program root;
                block36: {
                    ASTParser parser;
                    block35: {
                        frame = (PHPStackFrame)this.getFrame();
                        if (frame == null) {
                            return null;
                        }
                        this.expressionsUtil = ExpressionsUtil.getInstance((ExpressionsManager)this.getDebugTarget().getExpressionManager());
                        variable = null;
                        sourceModule = this.getEditorInputModelElement();
                        if (sourceModule != null) break block35;
                        return null;
                    }
                    root = SharedASTProvider.getAST((ISourceModule)sourceModule, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_NO, null);
                    if (root != null || (root = (parser = ASTParser.newParser((ISourceModule)sourceModule)).createAST(null)) != null) break block36;
                    return null;
                }
                node = NodeFinder.perform((ASTNode)root, (int)hoverRegion.getOffset(), (int)hoverRegion.getLength());
                if (node != null) break block37;
                return null;
            }
            try {
                if (node instanceof Scalar) {
                    Scalar scalar = (Scalar)node;
                    if (node.getParent() instanceof ArrayAccess) {
                        ArrayAccess access = (ArrayAccess)node.getParent();
                        Expression expression = this.expressionsUtil.buildExpression(this.computeExpression(access.getName()));
                        Expression[] children = expression.getValue().getOriChildren();
                        if (children != null && children.length > 0) {
                            Expression[] expressionArray = children;
                            int n = children.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Expression child = expressionArray[n2];
                                Object name = child.getLastName();
                                if (scalar.getScalarType() == 2) {
                                    name = "\"" + (String)name + "\"";
                                }
                                if (((String)name).equals(scalar.getStringValue())) {
                                    variable = new PHPVariable(this.getDebugTarget(), child);
                                }
                                ++n2;
                            }
                        }
                    } else if (!(scalar.getParent() instanceof Include || scalar.getScalarType() != 2 || scalar.getStringValue().startsWith("\"") && scalar.getStringValue().endsWith("\"") || scalar.getStringValue().trim().equals(""))) {
                        Expression constant = this.expressionsUtil.fetchConstant(scalar.getStringValue());
                        variable = new PHPVariable(this.getDebugTarget(), constant);
                    }
                    break block38;
                }
                if (node.getParent() instanceof Variable && node.getParent().getParent() instanceof FieldAccess && node instanceof Identifier) {
                    String nodeName = ((Identifier)node).getName();
                    String expression = this.computeExpression(((FieldAccess)node.getParent().getParent()).getDispatcher());
                    variable = this.fetchClassMember(expression, nodeName);
                    break block38;
                }
                if (node.getParent() instanceof StaticConstantAccess) {
                    String nodeName = ((Identifier)node).getName();
                    StaticConstantAccess staticAccess = (StaticConstantAccess)node.getParent();
                    String className = this.resolveTypeName((Identifier)staticAccess.getClassName());
                    if (className != null) {
                        variable = nodeName.equals("class") ? new PHPVariable(this.getDebugTarget(), this.expressionsUtil.fetchClassContext(className)) : this.fetchClassConstant(className, nodeName);
                    }
                    break block38;
                }
                if (node.getParent() instanceof StaticFieldAccess && node instanceof Variable && ((Variable)node).getName() instanceof Identifier) {
                    Variable var = (Variable)node;
                    String nodeName = ((Identifier)var.getName()).getName();
                    StaticFieldAccess staticAccess = (StaticFieldAccess)node.getParent();
                    Identifier identifier = null;
                    if (staticAccess.getClassName() instanceof Identifier) {
                        identifier = (Identifier)staticAccess.getClassName();
                        variable = this.fetchStaticMember(identifier, nodeName);
                    } else if (staticAccess.getClassName() instanceof VariableBase) {
                        identifier = (Identifier)var.getName();
                        variable = this.fetchStaticMember(identifier, nodeName);
                    }
                    break block38;
                }
                if (node.getParent() instanceof ConstantDeclaration) {
                    String nodeName = ((Identifier)node).getName();
                    IField field = (IField)sourceModule.getElementAt(node.getStart());
                    if (field.getParent() instanceof IType) {
                        IType type = (IType)field.getParent();
                        String typeName = type.getFullyQualifiedName("\\");
                        if (!PHPFlags.isNamespace((int)type.getFlags())) {
                            variable = this.fetchClassConstant(typeName, nodeName);
                        } else {
                            Expression constant = this.expressionsUtil.fetchConstant(typeName + "\\" + nodeName);
                            variable = new PHPVariable(this.getDebugTarget(), constant);
                        }
                    }
                    break block38;
                }
                if (node.getParent() instanceof SingleFieldDeclaration) {
                    IField field = (IField)sourceModule.getElementAt(node.getStart());
                    String typeName = "";
                    boolean isAnonymous = false;
                    if (field.getParent() instanceof IType) {
                        IType type = (IType)field.getParent();
                        typeName = type.getFullyQualifiedName("\\");
                        isAnonymous = PHPFlags.isAnonymous((int)type.getFlags());
                    }
                    Variable var = (Variable)node;
                    String nodeName = ((Identifier)var.getName()).getName();
                    if (!PHPFlags.isStatic((int)field.getFlags())) {
                        Expression e = this.expressionsUtil.buildExpression("$this");
                        if (isAnonymous || typeName.equals(e.getValue().getValue().toString())) {
                            variable = this.fetchClassMember(e, nodeName);
                        }
                    } else {
                        variable = this.fetchStaticMember(typeName, nodeName);
                    }
                    break block38;
                }
                Object variableName = null;
                if (node instanceof Identifier && node.getParent() instanceof Variable && !((Variable)node.getParent()).isDollared()) {
                    variableName = "$" + ((Identifier)node).getName();
                } else {
                    IDocument document = textViewer.getDocument();
                    if (document != null) {
                        variableName = node instanceof ReflectionVariable ? document.get(((ReflectionVariable)node).getName().getStart(), ((ReflectionVariable)node).getName().getLength()) : document.get(hoverRegion.getOffset(), hoverRegion.getLength());
                    }
                }
                IVariable[] iVariableArray = frame.getVariables();
                int n = iVariableArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IVariable stackVariable = iVariableArray[n3];
                    if (stackVariable.getName().equals(variableName)) {
                        variable = stackVariable;
                        break;
                    }
                    ++n3;
                }
            }
            catch (Exception e) {
                PHPDebugPlugin.log((Throwable)e);
            }
        }
        return variable;
    }

    protected String computeExpression(VariableBase node) {
        final StringBuilder dispatcher = new StringBuilder();
        node.accept((Visitor)new AbstractVisitor(){
            private boolean isFirstVariable = true;

            public boolean visit(Identifier identifier) {
                if (identifier.getParent() instanceof Identifier) {
                    String typeName = PHPDebugTextHover.this.resolveTypeName((Identifier)identifier.getParent());
                    if (typeName != null) {
                        dispatcher.append(typeName);
                    }
                } else if (identifier.getParent() instanceof Variable) {
                    Variable variable = (Variable)identifier.getParent();
                    if (variable.isDollared()) {
                        if (!this.isFirstVariable) {
                            dispatcher.append("::");
                        }
                        dispatcher.append("$");
                    } else if (!this.isFirstVariable) {
                        dispatcher.append("->");
                    }
                    dispatcher.append(((Identifier)variable.getName()).getName());
                }
                this.isFirstVariable = false;
                return false;
            }
        });
        return dispatcher.toString();
    }

    private PHPVariable fetchClassMember(String expression, String fieldName) {
        return this.fetchClassMember(this.expressionsUtil.buildExpression(expression), fieldName);
    }

    private PHPVariable fetchClassMember(Expression expression, String fieldName) {
        if (expression.getValue().getOriChildren() == null) {
            return null;
        }
        Expression[] expressionArray = expression.getValue().getOriChildren();
        int n = expressionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Expression child = expressionArray[n2];
            if (child.getLastName().endsWith(fieldName)) {
                return new PHPVariable(this.getDebugTarget(), child);
            }
            ++n2;
        }
        return null;
    }

    private PHPVariable fetchStaticMember(String className, String fieldName) {
        Expression[] staticMembers;
        Expression[] expressionArray = staticMembers = this.expressionsUtil.fetchStaticMembers(className);
        int n = staticMembers.length;
        int n2 = 0;
        while (n2 < n) {
            Expression child = expressionArray[n2];
            if (child.getLastName().endsWith(fieldName)) {
                return new PHPVariable(this.getDebugTarget(), child);
            }
            ++n2;
        }
        return null;
    }

    private PHPVariable fetchStaticMember(Identifier type, String fieldName) {
        String className = this.resolveTypeName(type);
        if (className != null) {
            return this.fetchStaticMember(className, fieldName);
        }
        return null;
    }

    private PHPVariable fetchClassConstant(String className, String constantName) {
        Expression[] constants;
        Expression[] expressionArray = constants = this.expressionsUtil.fetchClassConstants(className);
        int n = constants.length;
        int n2 = 0;
        while (n2 < n) {
            Expression child = expressionArray[n2];
            if (child.getLastName().equals(constantName)) {
                return new PHPVariable(this.getDebugTarget(), child);
            }
            ++n2;
        }
        return null;
    }

    protected String resolveTypeName(Identifier type) {
        ITypeBinding typeBinding = type.resolveTypeBinding();
        String className = null;
        if (typeBinding != null) {
            className = typeBinding.getName();
            if (className.startsWith("\\")) {
                className = className.substring(1);
            }
        } else {
            className = type.getName();
        }
        return className;
    }
}

