/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.filter;

import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.filter.ConnectionFilterComposite;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.filter.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.helpers.FilterHelper;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.util.resources.ResourceLoader;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilter;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilterImpl;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.PropertyPage;

public abstract class ConnectionFilterPropertyPage
extends PropertyPage
implements IConnectionFilterProvider {
    private static final ResourceLoader resource = ResourceLoader.getResourceLoader();
    protected ISelection selection;
    private Label descriptionLabel;
    private String DEFAULT_MESSAGE = resource.queryString("_UI_DESCRIPTION_FILTER");
    private static final String SELECTION_ONLY_MESSAGE = resource.queryString("_UI_DESCRIPTION_SELECTION_ONLY");
    private static final String EXPRESSION_ONLY_MESSAGE = resource.queryString("_UI_DESCRIPTION_EXPRESSION_ONLY");
    protected String defaultTitleText = resource.queryString("_UI_TITLE_FILTER_DIALOG");
    private ConnectionFilterComposite filterComposite;
    boolean hideSelectionOption = false;
    private boolean isMultiplePredicatesMode = false;
    private ConnectionFilter connFilter;

    public ConnectionFilterPropertyPage() {
        this.setTitle(this.getDefaultPageTitle());
    }

    @Override
    public void dataChanged() {
        this.setValid(this.validatePage());
    }

    public Table getSelectionTable() {
        return this.filterComposite.selectionTable;
    }

    public void setSelectionListPopulated(boolean populated) {
        this.filterComposite.isSelectionListPopulated = populated;
    }

    protected Control createContents(Composite parent) {
        return this.createContents(parent, false);
    }

    protected Control createContents(Composite parent, boolean hideExpressionOption) {
        this.isMultiplePredicatesMode = FilterHelper.INSTANCE.supportsMultiplePredicatesMode(this.getElement());
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 5;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        GridData gd = null;
        this.descriptionLabel = new Label(composite, 64);
        this.descriptionLabel.setText(this.DEFAULT_MESSAGE);
        gd = new GridData();
        gd.verticalAlignment = 1;
        gd.horizontalIndent = -5;
        this.descriptionLabel.setLayoutData((Object)gd);
        Label spacer = new Label(composite, 0);
        spacer.setText(" ");
        gd = new GridData();
        gd.verticalAlignment = 1;
        spacer.setLayoutData((Object)gd);
        if (!this.isMultiplePredicatesMode) {
            this.filterComposite = new ConnectionFilterComposite(composite, 0, this, hideExpressionOption, this.hideSelectionOption);
            this.filterComposite.initializeValues();
        } else {
            this.connFilter = this.getConnectionFilter();
            if (this.connFilter == null) {
                this.connFilter = new ConnectionFilterImpl();
            }
            this.filterComposite = new ConnectionFilterComposite(composite, 0, this, hideExpressionOption, this.hideSelectionOption, this.isMultiplePredicatesMode, this.connFilter, this);
            this.filterComposite.initializeValues();
        }
        if (this.filterComposite.isHideExpressionOption()) {
            this.DEFAULT_MESSAGE = SELECTION_ONLY_MESSAGE;
            this.setDescription(this.DEFAULT_MESSAGE);
        } else if (this.filterComposite.isHideSelectionOption()) {
            this.DEFAULT_MESSAGE = EXPRESSION_ONLY_MESSAGE;
            this.setDescription(this.DEFAULT_MESSAGE);
        } else {
            this.setDescription(this.DEFAULT_MESSAGE);
        }
        this.initializeDialogUnits((Control)composite);
        this.setValid(this.validatePage());
        return composite;
    }

    protected void setPageValidity() {
        this.setValid(this.validatePage());
    }

    protected boolean validatePage() {
        boolean isValid = true;
        if (this.filterComposite != null) {
            isValid = this.filterComposite.validatePage((DialogPage)this);
        }
        if (isValid) {
            this.setMessage(null);
            this.setErrorMessage(null);
            this.setDescription(this.DEFAULT_MESSAGE);
            this.setTitle(this.getDefaultPageTitle());
            this.setValid(isValid);
        }
        return isValid;
    }

    public String getPredicate() {
        return this.filterComposite.getPredicate();
    }

    public String getPredicates() {
        return this.filterComposite.getPredicates();
    }

    public boolean isFilterSpecified() {
        return this.filterComposite.isFilterSpecified();
    }

    public boolean isIncludeSelected() {
        return this.filterComposite.isIncludeSelected();
    }

    @Override
    public void populateSelectionTable(Table selectionTable) {
        String predicate = this.getCurrentPredicate();
        this.setConnectionFilter(null);
        this.filterComposite.setSelection(this.selection);
        this.filterComposite.populateSelectionTable(selectionTable);
        this.setConnectionFilter(predicate);
    }

    @Override
    public abstract ConnectionFilter getConnectionFilter();

    protected abstract IConnectionProfile getConnectionProfile();

    protected abstract String getConnectionFilterType();

    public boolean performOk() {
        String filterType = this.getConnectionFilterType();
        if (filterType != null) {
            String predicate = null;
            predicate = !this.isMultiplePredicatesMode ? this.getPredicate() : this.getPredicates();
            this.setConnectionFilter(predicate);
        }
        return true;
    }

    private String getCurrentPredicate() {
        String predicate = null;
        String filterType = this.getConnectionFilterType();
        if (filterType != null) {
            IConnectionProfile profile = this.getConnectionProfile();
            Properties props = profile.getProperties("org.eclipse.datatools.connectivity.sqm.filterSettings");
            predicate = props.getProperty(filterType);
        }
        return predicate;
    }

    private void setConnectionFilter(String predicate) {
        String filterType = this.getConnectionFilterType();
        if (filterType != null) {
            IConnectionProfile profile = this.getConnectionProfile();
            Properties props = profile.getProperties("org.eclipse.datatools.connectivity.sqm.filterSettings");
            if (predicate == null || predicate.length() == 0) {
                props.remove(filterType);
            } else {
                props.setProperty(filterType, predicate);
            }
            profile.setProperties("org.eclipse.datatools.connectivity.sqm.filterSettings", props);
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        this.filterComposite.performDefaults();
        this.setErrorMessage(null);
        this.setValid(true);
    }

    protected void performApply() {
        String filterType = this.getConnectionFilterType();
        if (filterType != null) {
            String predicate = null;
            predicate = !this.isMultiplePredicatesMode ? this.getPredicate() : this.getPredicates();
            this.setConnectionFilter(predicate);
        }
    }

    public void setDefaultPageTitle(String title) {
        this.defaultTitleText = title;
    }

    public String getDefaultPageTitle() {
        return this.defaultTitleText;
    }

    public boolean getHideSelectionOption() {
        return this.hideSelectionOption;
    }

    public void setHideSelectionOption(boolean flag) {
        this.hideSelectionOption = flag;
    }

    public void setDescription(String description) {
        if (this.descriptionLabel != null) {
            this.descriptionLabel.setText(description);
        }
    }
}

