/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.internal.ssh;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;

public class AuthorizedKeys {
    private static final String PREFIX_KEY_TYPE = "ssh-";
    private static final String PREFIX_KEY_TYPE_DSA = "ssh-dsa ";
    private static final String PREFIX_KEY_TYPE_RSA = "ssh-rsa ";
    private static final String NEWLINE = "\n";
    private final List<PublicKey> keys;

    private static byte[] asBytes(String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }

    private static String asString(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static void main(String[] args) {
        try {
            List<PublicKey> keys = new AuthorizedKeys(args[0]).getKeys();
            for (PublicKey key : keys) {
                System.out.println(key);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AuthorizedKeys(String authorizedKeysFile) throws FileNotFoundException, IOException {
        File file = new File(authorizedKeysFile);
        Throwable throwable = null;
        Object var4_5 = null;
        try (Scanner scanner = new Scanner(file);){
            scanner.useDelimiter(NEWLINE);
            int lineNumber = 0;
            ArrayList<PublicKey> keys = new ArrayList<PublicKey>();
            while (scanner.hasNext()) {
                ++lineNumber;
                String line = scanner.next().trim();
                if (line.length() == 0 || line.charAt(0) == '#') continue;
                try {
                    keys.add(this.readPublicKey(line));
                }
                catch (Exception e) {
                    throw new ParseKeyException("Line " + lineNumber + ": " + e.getMessage(), e);
                }
            }
            this.keys = Collections.unmodifiableList(keys);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public List<PublicKey> getKeys() {
        return this.keys;
    }

    private BigInteger readBigInteger(ByteBuffer buffer) {
        int len = buffer.getInt();
        byte[] bytes = new byte[len];
        buffer.get(bytes);
        BigInteger pubExp = new BigInteger(bytes);
        return pubExp;
    }

    private PublicKey readPublicKey(String line) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        byte[] key;
        KeyType type;
        if (!line.startsWith(PREFIX_KEY_TYPE)) {
            int keyTypeStart = line.indexOf(PREFIX_KEY_TYPE);
            if (keyTypeStart == -1) {
                throw new IOException("missing key type");
            }
            line = line.substring(keyTypeStart);
        }
        if (line.startsWith(PREFIX_KEY_TYPE_DSA)) {
            line = line.substring(PREFIX_KEY_TYPE_DSA.length());
            type = KeyType.DSA;
        } else if (line.startsWith(PREFIX_KEY_TYPE_RSA)) {
            line = line.substring(PREFIX_KEY_TYPE_RSA.length());
            type = KeyType.RSA;
        } else {
            throw new IOException("unsupported key type");
        }
        int keyEndIdx = line.indexOf(32);
        if (keyEndIdx != -1) {
            key = Base64.getDecoder().decode(AuthorizedKeys.asBytes(line.substring(0, keyEndIdx)));
            line = line.substring(keyEndIdx + 1);
        } else {
            key = Base64.getDecoder().decode(AuthorizedKeys.asBytes(line));
        }
        ByteBuffer buffer = ByteBuffer.wrap(key);
        this.readString(buffer);
        switch (type) {
            case RSA: {
                BigInteger pubExp = this.readBigInteger(buffer);
                BigInteger mod = this.readBigInteger(buffer);
                return KeyFactory.getInstance(KeyType.RSA.name()).generatePublic(new RSAPublicKeySpec(mod, pubExp));
            }
            case DSA: {
                BigInteger p = this.readBigInteger(buffer);
                BigInteger q = this.readBigInteger(buffer);
                BigInteger g = this.readBigInteger(buffer);
                BigInteger y = this.readBigInteger(buffer);
                return KeyFactory.getInstance(KeyType.DSA.name()).generatePublic(new DSAPublicKeySpec(y, p, q, g));
            }
        }
        throw new IOException("not implemented: " + String.valueOf((Object)type));
    }

    private String readString(ByteBuffer buffer) {
        int len = buffer.getInt();
        byte[] bytes = new byte[len];
        buffer.get(bytes);
        return AuthorizedKeys.asString(bytes);
    }

    public static enum KeyType {
        RSA,
        DSA;

    }

    public static class ParseKeyException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public ParseKeyException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

