/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.builder;

import java.util.logging.Level;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.jpa.eclipselink.core.EclipseLinkJpaPreferences;
import org.eclipse.jpt.jpa.eclipselink.core.builder.EclipseLinkStaticWeavingBuilder;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkLoggingLevel;

public class EclipseLinkStaticWeavingBuilderConfigurator {
    private final IProject project;
    private static final String BUILDER_ID = EclipseLinkStaticWeavingBuilder.BUILDER_ID;

    public EclipseLinkStaticWeavingBuilderConfigurator(IProject project) {
        this.project = project;
    }

    public void addBuilder() {
        try {
            IProjectDescription description = this.project.getDescription();
            ICommand[] commands = description.getBuildSpec();
            ICommand newCommand = description.newCommand();
            newCommand.setBuilderName(BUILDER_ID);
            ICommand[] newCommands = null;
            if (commands != null) {
                newCommands = new ICommand[commands.length + 1];
                System.arraycopy(commands, 0, newCommands, 0, commands.length);
                newCommands[commands.length] = newCommand;
            } else {
                newCommands = new ICommand[]{newCommand};
            }
            description.setBuildSpec(newCommands);
            this.project.setDescription(description, null);
        }
        catch (CoreException coreException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean projectHasStaticWeavingBuilder() {
        try {
            IProjectDescription description = this.project.getDescription();
            ICommand[] commands = description.getBuildSpec();
            if (commands.length == 0) {
                return false;
            }
            int i = 0;
            while (true) {
                if (i >= commands.length) {
                    return false;
                }
                if (commands[i].getBuilderName().equals(BUILDER_ID)) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public void removeBuilder() {
        try {
            IProjectDescription description = this.project.getDescription();
            ICommand[] commands = description.getBuildSpec();
            if (commands.length == 0) {
                return;
            }
            int newLength = 0;
            int i = 0;
            while (i < commands.length) {
                if (commands[i].getBuilderName().equals(BUILDER_ID)) {
                    commands[i] = null;
                } else {
                    ++newLength;
                }
                ++i;
            }
            if (newLength == commands.length) {
                return;
            }
            ICommand[] newCommands = new ICommand[newLength];
            int i2 = 0;
            int j = 0;
            while (i2 < commands.length) {
                if (commands[i2] != null) {
                    newCommands[j++] = commands[i2];
                }
                ++i2;
            }
            description.setBuildSpec(newCommands);
            this.project.setDescription(description, 0, null);
        }
        catch (CoreException coreException) {
            return;
        }
    }

    public String getSourceLocationPreference() {
        return EclipseLinkJpaPreferences.getStaticWeavingSourceLocation(this.project, this.getDefaultSourceLocation());
    }

    public String getTargetLocationPreference() {
        return EclipseLinkJpaPreferences.getStaticWeavingTargetLocation(this.project, this.getDefaultTargetLocation());
    }

    public String getPersistenceInfoPreference() {
        return EclipseLinkJpaPreferences.getStaticWeavingPersistenceInfo(this.project, this.getDefaultPersistenceInfo());
    }

    public String getLogLevelPreference() {
        return EclipseLinkJpaPreferences.getStaticWeavingLogLevel(this.project, this.getDefaultLogLevel());
    }

    public String getDefaultSourceLocation() {
        return this.getJavaProjectOutputLocation();
    }

    public String getDefaultTargetLocation() {
        return this.getJavaProjectOutputLocation();
    }

    public String getDefaultPersistenceInfo() {
        return null;
    }

    public String getDefaultLogLevel() {
        return Level.SEVERE.getName();
    }

    public EclipseLinkLoggingLevel[] getLogLevelValues() {
        return EclipseLinkLoggingLevel.values();
    }

    public void setSourceLocationPreference(String location) {
        EclipseLinkJpaPreferences.setStaticWeavingSourceLocation(this.project, location);
    }

    public void removeSourceLocationPreference() {
        EclipseLinkJpaPreferences.setStaticWeavingSourceLocation(this.project, null);
    }

    public void setTargetLocationPreference(String location) {
        EclipseLinkJpaPreferences.setStaticWeavingTargetLocation(this.project, location);
    }

    public void removeTargetLocationPreference() {
        EclipseLinkJpaPreferences.setStaticWeavingTargetLocation(this.project, null);
    }

    public void setLogLevelPreference(String logLevel) {
        EclipseLinkJpaPreferences.setStaticWeavingLogLevel(this.project, logLevel);
    }

    public void removeLogLevelPreference() {
        EclipseLinkJpaPreferences.setStaticWeavingLogLevel(this.project, null);
    }

    public void setPersistenceInfoPreference(String info) {
        EclipseLinkJpaPreferences.setStaticWeavingPersistenceInfo(this.project, info);
    }

    public void removePersistenceInfoPreference() {
        EclipseLinkJpaPreferences.setStaticWeavingPersistenceInfo(this.project, null);
    }

    private String getJavaProjectOutputLocation() {
        try {
            return this.getJavaProjectOutputLocationPath().toOSString();
        }
        catch (CoreException coreException) {
            return ".";
        }
    }

    private IPath getJavaProjectOutputLocationPath() throws CoreException {
        IPath outputLocation = this.getJavaProject().getOutputLocation();
        String projectName = outputLocation.segment(0);
        if (this.project.getName().equals(projectName)) {
            outputLocation = outputLocation.removeFirstSegments(1);
        }
        return outputLocation;
    }

    private IJavaProject getJavaProject() {
        return JavaCore.create((IProject)this.project);
    }
}

