/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.common.core.internal.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.modisco.infra.common.core.internal.utils.StringUtils;

public final class ModelUtils {
    private static ResourceSet resourceSet = new ResourceSetImpl();
    private static AdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);

    private ModelUtils() {
    }

    public static Resource loadModel(File file) throws IOException {
        URI modelURI = URI.createFileURI((String)file.getPath());
        return ModelUtils.loadModel(modelURI);
    }

    public static Resource loadModel(URI modelURI) throws IOException {
        Resource.Factory.Registry reg;
        Object resourceFactory;
        String fileExtension = modelURI.fileExtension();
        if (fileExtension == null || fileExtension.length() == 0) {
            fileExtension = "*";
        }
        if ((resourceFactory = (reg = Resource.Factory.Registry.INSTANCE).getExtensionToFactoryMap().get(fileExtension)) != null) {
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileExtension, resourceFactory);
        } else {
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileExtension, new XMIResourceFactoryImpl());
        }
        Resource result = resourceSet.createResource(modelURI);
        if (result != null) {
            result.load(null);
        }
        return result;
    }

    private static Set<EObject> getElementsByType(Resource extent, String type) {
        HashSet<EObject> ret = new HashSet<EObject>();
        TreeIterator i = extent.getAllContents();
        while (i.hasNext()) {
            EObject eo = (EObject)i.next();
            if (!eo.eClass().getName().equals(type)) continue;
            ret.add(eo);
        }
        return ret;
    }

    public static void registerMetamodel(URI metamodelURI) throws IOException {
        if (EPackage.Registry.INSTANCE.getEPackage(metamodelURI.toString()) != null) {
            return;
        }
        EcoreResourceFactoryImpl myEcoreFactory = new EcoreResourceFactoryImpl();
        Resource mmExtent = myEcoreFactory.createResource(metamodelURI);
        mmExtent.load((InputStream)new FileInputStream(metamodelURI.toFileString()), Collections.EMPTY_MAP);
        for (EObject eObject : ModelUtils.getElementsByType(mmExtent, "EPackage")) {
            EPackage p = (EPackage)eObject;
            String nsURI = p.getNsURI();
            if (nsURI == null) {
                nsURI = p.getName();
                p.setNsURI(nsURI);
            }
            EPackage.Registry.INSTANCE.put((Object)nsURI, (Object)p);
        }
        for (EObject eo : ModelUtils.getElementsByType(mmExtent, "EDataType")) {
            EStructuralFeature sf = eo.eClass().getEStructuralFeature("name");
            String tname = (String)eo.eGet(sf);
            String icn = null;
            if (tname.equals("Boolean")) {
                icn = "java.lang.Boolean";
            } else if (tname.equals("Double") || tname.equals("Real")) {
                icn = "java.lang.Double";
            } else if (tname.equals("Float")) {
                icn = "java.lang.Float";
            } else if (tname.equals("Integer")) {
                icn = "java.lang.Integer";
            } else if (tname.equals("String")) {
                icn = "java.lang.String";
            }
            if (icn == null) continue;
            sf = eo.eClass().getEStructuralFeature("instanceClassName");
            eo.eSet(sf, (Object)icn);
        }
    }

    public static String serialize(EObject root) throws IOException {
        if (root == null) {
            throw new NullPointerException("ModelUtils.NullSaveRoot");
        }
        XMIResourceImpl newResource = new XMIResourceImpl();
        StringWriter writer = new StringWriter();
        newResource.getContents().add((Object)root);
        newResource.save((Writer)writer, Collections.EMPTY_MAP);
        return writer.toString();
    }

    public static String getName(EObject eObject) {
        IItemLabelProvider itemLabelProvider = (IItemLabelProvider)composedAdapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class);
        if (itemLabelProvider != null) {
            return itemLabelProvider.getText((Object)eObject);
        }
        return ModelUtils.getDefaultName(eObject);
    }

    public static String getDefaultName(EObject eObject) {
        Object value;
        EStructuralFeature feature = ModelUtils.getLabelFeature(eObject.eClass());
        if (feature != null && (value = eObject.eGet(feature)) != null) {
            return StringUtils.truncateBeforeNewline(value.toString());
        }
        if (eObject.eIsProxy()) {
            return StringUtils.truncateBeforeNewline(EcoreUtil.getURI((EObject)eObject).toString());
        }
        return "";
    }

    private static EStructuralFeature getLabelFeature(EClass eClass) {
        EAttribute result = null;
        for (EAttribute eAttribute : eClass.getEAllAttributes()) {
            if (eAttribute.isMany() || eAttribute.getEType().getInstanceClass() == FeatureMap.Entry.class) continue;
            if ("name".equalsIgnoreCase(eAttribute.getName())) {
                result = eAttribute;
                break;
            }
            if (result == null) {
                result = eAttribute;
                continue;
            }
            if (eAttribute.getEAttributeType().getInstanceClass() != String.class || result.getEAttributeType().getInstanceClass() == String.class) continue;
            result = eAttribute;
        }
        return result;
    }

    public static String getMetaclassQualifiedName(EClassifier eClass) {
        ArrayList<String> qualifiedNameParts = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        EPackage ePackage = eClass.getEPackage();
        while (ePackage != null) {
            qualifiedNameParts.add(ePackage.getName());
            ePackage = ePackage.getESuperPackage();
        }
        int i = qualifiedNameParts.size() - 1;
        while (i >= 0) {
            builder.append(String.valueOf((String)qualifiedNameParts.get(i)) + ".");
            --i;
        }
        builder.append(eClass.getName());
        return builder.toString();
    }

    public static IFile getIFileFormEObject(EObject eObject) {
        URI uri = eObject.eResource().getURI();
        return ModelUtils.getIFileFromPlatformURI(uri);
    }

    public static IFile getIFileFromPlatformURI(URI uri) {
        IFile iFile = null;
        if (uri.isPlatformResource()) {
            String projectName = uri.segment(1);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            StringBuilder path = new StringBuilder();
            String[] segments = uri.segments();
            int i = 2;
            while (i < segments.length) {
                path.append("/").append(segments[i]);
                ++i;
            }
            iFile = project.getFile(path.toString());
        }
        return iFile;
    }

    public static void computeReferencedResources(Resource resource, Set<Resource> allReferencedResources) {
        if (resource == null) {
            return;
        }
        HashSet<Resource> directReferencedResources = new HashSet<Resource>();
        for (EObject root : resource.getContents()) {
            Map externalReferences = EcoreUtil.ExternalCrossReferencer.find((EObject)root);
            if (externalReferences.isEmpty()) continue;
            for (EObject external : externalReferences.keySet()) {
                Resource externalResource = external.eIsProxy() ? EcoreUtil.resolve((EObject)external, (EObject)root).eResource() : external.eResource();
                if (externalResource == null) continue;
                directReferencedResources.add(externalResource);
            }
        }
        for (Resource directlyReferencedResource : directReferencedResources) {
            if (allReferencedResources.contains(directlyReferencedResource)) continue;
            allReferencedResources.add(directlyReferencedResource);
            ModelUtils.computeReferencedResources(directlyReferencedResource, allReferencedResources);
        }
    }

    public static Set<URI> computeReferencedResourcesURIs(Resource resource) {
        if (resource == null) {
            return null;
        }
        HashSet<URI> referencedResourceURIs = new HashSet<URI>();
        CrossReferencer crossReferencer = new CrossReferencer(resource);
        crossReferencer.findReferences();
        if (!crossReferencer.isEmpty()) {
            for (EObject externalEObject : crossReferencer.keySet()) {
                URI uri = EcoreUtil.getURI((EObject)externalEObject);
                if (uri == null) continue;
                referencedResourceURIs.add(uri.trimFragment());
            }
        }
        return referencedResourceURIs;
    }

    public static Set<EPackage> computeReferencedPackages(EPackage aPackage) {
        HashSet<Resource> referencedResources = new HashSet<Resource>();
        HashSet<EPackage> referencedPackages = new HashSet<EPackage>();
        ModelUtils.computeReferencedResources(aPackage.eResource(), referencedResources);
        for (Resource aReferencedResource : referencedResources) {
            TreeIterator allContents = aReferencedResource.getAllContents();
            while (allContents.hasNext()) {
                EObject eObject = (EObject)allContents.next();
                if (!(eObject instanceof EPackage)) continue;
                referencedPackages.add((EPackage)eObject);
            }
        }
        return referencedPackages;
    }

    private static class CrossReferencer
    extends EcoreUtil.CrossReferencer {
        private static final long serialVersionUID = 4564174659913803329L;

        public CrossReferencer(Resource resource) {
            super(resource);
        }

        protected boolean resolve() {
            return false;
        }

        public EcoreUtil.CrossReferencer findReferences() {
            this.crossReference();
            this.done();
            return this;
        }
    }
}

