/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.targetdefinition;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.targetdefinition.TargetEditor;
import org.eclipse.pde.internal.ui.views.target.StateTree;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.osgi.framework.FrameworkUtil;

public class StatePage
extends FormPage {
    public static final String PAGE_ID = "state";
    private State state;
    private StateTree stateTree;
    private ITargetDefinition target;
    private Job job;
    private boolean active;

    public StatePage(TargetEditor editor) {
        super((FormEditor)editor, PAGE_ID, PDEUIMessages.StatePage_title);
    }

    public void createPartControl(Composite parent) {
        this.stateTree = new StateTree(parent);
        this.stateTree.setInput(this.state);
    }

    public Control getPartControl() {
        return this.stateTree;
    }

    public void setActive(boolean active) {
        this.active = active;
        super.setActive(active);
        this.loadState();
    }

    private void loadState() {
        if (!this.active || this.state != null || this.target == null) {
            return;
        }
        TargetBundle[] targetBundles = this.target.getBundles();
        if (targetBundles == null || targetBundles.length == 0) {
            return;
        }
        this.job = Job.create((String)"Compute Target State", monitor -> {
            try {
                State targetState = BundleHelper.getPlatformAdmin().getFactory().createState(true);
                targetState.setPlatformProperties(PDECore.getDefault().getModelManager().getState().getState().getPlatformProperties());
                StateObjectFactory factory = targetState.getFactory();
                long id = 1L;
                TargetBundle[] targetBundleArray2 = targetBundles;
                int n = targetBundles.length;
                int n2 = 0;
                while (n2 < n) {
                    TargetBundle targetBundle = targetBundleArray2[n2];
                    if (!targetBundle.isSourceBundle()) {
                        BundleInfo bundleInfo = targetBundle.getBundleInfo();
                        String manifest = bundleInfo.getManifest();
                        if (manifest != null) {
                            Map bundleManifest;
                            Throwable throwable = null;
                            Object var15_16 = null;
                            try (ByteArrayInputStream stream = new ByteArrayInputStream(manifest.getBytes(StandardCharsets.UTF_8));){
                                bundleManifest = ManifestElement.parseBundleManifest((InputStream)stream);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            BundleDescription bundleDescription = factory.createBundleDescription(targetState, FrameworkUtil.asDictionary((Map)bundleManifest), String.valueOf(targetBundle.getBundleInfo().getLocation()), id++);
                            targetState.addBundle(bundleDescription);
                        }
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                    }
                    ++n2;
                }
                targetState.resolve(false);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                PlatformUI.getWorkbench().getDisplay().execute(() -> {
                    this.state = targetState;
                    if (this.stateTree != null) {
                        this.stateTree.setInput(targetState);
                    }
                });
            }
            catch (Exception e) {
                ILog.get().error("Computing target state failed!", (Throwable)e);
            }
            return Status.OK_STATUS;
        });
        this.job.schedule();
    }

    public void reset() {
        PlatformUI.getWorkbench().getDisplay().execute(() -> {
            this.update(null);
            if (this.stateTree != null) {
                this.stateTree.setInput(null);
            }
        });
    }

    protected void update(ITargetDefinition target) {
        if (this.job != null) {
            this.job.cancel();
            this.job = null;
        }
        this.state = null;
        this.target = target;
    }

    public void updateTarget(ITargetDefinition target) {
        PlatformUI.getWorkbench().getDisplay().execute(() -> {
            this.update(target);
            this.loadState();
        });
    }
}

