/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.commands.emf;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.MessageTranslator;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.common.tools.api.util.TreeItemWrapper;
import org.eclipse.sirius.common.ui.tools.api.selection.EObjectPaneBasedSelectionWizard;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.emf.AbstractSelectionWizardCommand;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.PaneBasedSelectionWizardDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class PaneBasedSelectionWizardCommand
extends AbstractSelectionWizardCommand {
    private final IDiagramCommandFactory factory;
    private final PaneBasedSelectionWizardDescription tool;
    private final TreeItemWrapper input;
    private final DSemanticDecorator containerView;

    public PaneBasedSelectionWizardCommand(IDiagramCommandFactory factory, PaneBasedSelectionWizardDescription tool, TreeItemWrapper input, DSemanticDecorator containerView) {
        super(TransactionUtil.getEditingDomain((EObject)containerView));
        this.factory = factory;
        this.tool = tool;
        this.input = input;
        this.containerView = containerView;
    }

    public void doExecute() {
        this.computeInput();
        Collection<EObject> preSelection = this.computePreSelection();
        Shell shell = null;
        boolean createdShell = false;
        if (PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
            shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        if (shell == null) {
            shell = new Shell();
            createdShell = true;
        }
        String windowTitleLocalized = MessageTranslator.INSTANCE.getMessage((EObject)this.tool, this.tool.getWindowTitle());
        String messageLocalized = MessageTranslator.INSTANCE.getMessage((EObject)this.tool, this.tool.getMessage());
        String choiceOfValuesMessageLocalized = MessageTranslator.INSTANCE.getMessage((EObject)this.tool, this.tool.getChoiceOfValuesMessage());
        String selectedValuesMessageLocalized = MessageTranslator.INSTANCE.getMessage((EObject)this.tool, this.tool.getSelectedValuesMessage());
        EObjectPaneBasedSelectionWizard wizard = new EObjectPaneBasedSelectionWizard(windowTitleLocalized, messageLocalized, this.getImage(), choiceOfValuesMessageLocalized, selectedValuesMessageLocalized, DiagramUIPlugin.getPlugin().getItemProvidersAdapterFactory());
        wizard.init(this.input, preSelection);
        WizardDialog dlg = new WizardDialog(shell, (IWizard)wizard);
        dlg.setMinimumPageSize(200, 300);
        int result = dlg.open();
        if (result == 0) {
            Collection selectedElements = wizard.getSelectedEObjects();
            IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(this.containerView.getTarget());
            interpreter.setVariable(this.tool.getContainerView().getName(), (Object)this.containerView);
            Option diagram = new EObjectQuery((EObject)this.containerView).getParentDiagram();
            if (diagram.some()) {
                interpreter.setVariable("diagram", diagram.get());
            } else {
                interpreter.setVariable("diagram", null);
            }
            interpreter.setVariable("containerView", (Object)this.containerView);
            interpreter.setVariable("container", (Object)this.containerView.getTarget());
            Command command = this.factory.buildPaneBasedSelectionWizardCommandFromTool(this.tool, this.containerView, selectedElements);
            command.execute();
            interpreter.unSetVariable(this.tool.getContainerView().getName());
            interpreter.unSetVariable("diagram");
            interpreter.unSetVariable("containerView");
            interpreter.unSetVariable("container");
        } else if (this.containerView instanceof AbstractDNode) {
            SiriusLayoutDataManager.INSTANCE.getData((AbstractDNode)this.containerView);
        }
        if (createdShell) {
            shell.dispose();
        }
    }

    private ImageDescriptor getImage() {
        if (StringUtil.isEmpty((String)this.tool.getWindowImagePath())) {
            return null;
        }
        return DiagramUIPlugin.Implementation.findImageDescriptor(this.tool.getWindowImagePath());
    }

    public String getLabel() {
        return this.tool.getName();
    }

    private void computeInput() {
        EObject container = this.containerView.getTarget();
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(container);
        if (AbstractSelectionWizardCommand.checkPrecondition((AbstractToolDescription)this.tool, (EObject)this.containerView, container)) {
            interpreter.setVariable(this.tool.getContainerView().getName(), (Object)this.containerView);
            Option diagram = new EObjectQuery((EObject)this.containerView).getParentDiagram();
            if (diagram.some()) {
                interpreter.setVariable("diagram", diagram.get());
            } else {
                interpreter.setVariable("diagram", null);
            }
            interpreter.setVariable("containerView", (Object)this.containerView);
            interpreter.setVariable("container", (Object)container);
            PaneBasedSelectionWizardCommand.computeInput(this.tool, container, interpreter, this.input);
            interpreter.unSetVariable(this.tool.getContainerView().getName());
            interpreter.unSetVariable("diagram");
            interpreter.unSetVariable("containerView");
            interpreter.unSetVariable("container");
        }
    }

    private Collection<EObject> computePreSelection() {
        Collection<Object> preSelection = Collections.emptyList();
        EObject container = this.containerView.getTarget();
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(container);
        if (AbstractSelectionWizardCommand.checkPrecondition((AbstractToolDescription)this.tool, (EObject)this.containerView, container)) {
            interpreter.setVariable(this.tool.getContainerView().getName(), (Object)this.containerView);
            Option diagram = new EObjectQuery((EObject)this.containerView).getParentDiagram();
            if (diagram.some()) {
                interpreter.setVariable("diagram", diagram.get());
            } else {
                interpreter.setVariable("diagram", null);
            }
            interpreter.setVariable("containerView", (Object)this.containerView);
            interpreter.setVariable("container", (Object)container);
            preSelection = RuntimeLoggerManager.INSTANCE.decorate(interpreter).evaluateCollection(container, (EObject)this.tool, (EStructuralFeature)ToolPackage.eINSTANCE.getPaneBasedSelectionWizardDescription_PreSelectedCandidatesExpression());
            interpreter.unSetVariable(this.tool.getContainerView().getName());
            interpreter.unSetVariable("containerView");
            interpreter.unSetVariable("container");
            interpreter.unSetVariable("diagram");
        }
        return preSelection;
    }

    private static void computeInput(PaneBasedSelectionWizardDescription paneBasedSelectionWizardDescription, EObject container, IInterpreter interpreter, TreeItemWrapper input) {
        ImmutableSet referencingENode = ImmutableSet.copyOf((Collection)RuntimeLoggerManager.INSTANCE.decorate(interpreter).evaluateCollection(container, (EObject)paneBasedSelectionWizardDescription, (EStructuralFeature)ToolPackage.eINSTANCE.getPaneBasedSelectionWizardDescription_CandidatesExpression()));
        if (paneBasedSelectionWizardDescription.isTree()) {
            Collection referencingRoots = RuntimeLoggerManager.INSTANCE.decorate(interpreter).evaluateCollection(container, (EObject)paneBasedSelectionWizardDescription, (EStructuralFeature)ToolPackage.eINSTANCE.getPaneBasedSelectionWizardDescription_RootExpression());
            for (EObject refRoot : referencingRoots) {
                if (!referencingENode.contains(refRoot)) continue;
                TreeItemWrapper treeItem = new TreeItemWrapper((Object)refRoot, input);
                input.getChildren().add(treeItem);
                PaneBasedSelectionWizardCommand.computeChildren(paneBasedSelectionWizardDescription, (Collection<EObject>)referencingENode, interpreter, treeItem, refRoot);
            }
        } else {
            for (EObject refRoot : referencingENode) {
                TreeItemWrapper treeItem = new TreeItemWrapper((Object)refRoot, input);
                input.getChildren().add(treeItem);
            }
        }
    }

    private static void computeChildren(PaneBasedSelectionWizardDescription paneBasedSelectionWizardDescription, Collection<EObject> referencingENode, IInterpreter interpreter, TreeItemWrapper parent, EObject refParent) {
        Collection referencingChilds = RuntimeLoggerManager.INSTANCE.decorate(interpreter).evaluateCollection(refParent, (EObject)paneBasedSelectionWizardDescription, (EStructuralFeature)ToolPackage.eINSTANCE.getPaneBasedSelectionWizardDescription_ChildrenExpression());
        for (EObject refElement : referencingChilds) {
            if (!referencingENode.contains(refElement) || parent.knownThisAsAncestor((Object)refElement)) continue;
            TreeItemWrapper treeItem = new TreeItemWrapper((Object)refElement, parent);
            parent.getChildren().add(treeItem);
            PaneBasedSelectionWizardCommand.computeChildren(paneBasedSelectionWizardDescription, referencingENode, interpreter, treeItem, refElement);
        }
    }
}

