/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ext.draw2d.figure;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.sirius.ext.draw2d.figure.MouseAwareImageFigure;
import org.eclipse.swt.graphics.Image;

public class ActionTriggerImageFigure
extends MouseAwareImageFigure {
    protected Image clickedImage;
    private List<Runnable> actions;
    private ActionTrigger actionTrigger;

    public ActionTriggerImageFigure() {
        this.init();
    }

    public ActionTriggerImageFigure(Image imageWOFocus, Image imageWFocus) {
        super(imageWOFocus, imageWFocus);
        this.init();
    }

    public ActionTriggerImageFigure(Image imageWOFocus) {
        super(imageWOFocus);
        this.init();
    }

    private void init() {
        this.actions = new LinkedList<Runnable>();
        this.actionTrigger = new ActionTrigger();
        this.addMouseListener(this.actionTrigger);
    }

    public void trigger() {
        for (Runnable action : this.actions) {
            action.run();
        }
    }

    public void addAction(Runnable simpleAction) {
        this.actions.add(simpleAction);
    }

    public void addAction(Runnable simpleAction, int index) {
        this.actions.add(index, simpleAction);
    }

    public void clearActions() {
        this.actions.clear();
    }

    public void removeAction(Runnable simpleAction) {
        this.actions.remove(simpleAction);
    }

    public Iterator<Runnable> iterActions() {
        return this.actions.iterator();
    }

    public void setClickedImage(Image clickedImage) {
        this.clickedImage = clickedImage;
    }

    private final class ActionTrigger
    implements MouseListener {
        private ActionTrigger() {
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }

        public void mousePressed(MouseEvent me) {
            if (ActionTriggerImageFigure.this.clickedImage != null) {
                ActionTriggerImageFigure.this.setImage(ActionTriggerImageFigure.this.clickedImage);
            }
            ActionTriggerImageFigure.this.trigger();
            me.consume();
        }

        public void mouseReleased(MouseEvent me) {
            if (ActionTriggerImageFigure.this.getImage() == ActionTriggerImageFigure.this.clickedImage) {
                ActionTriggerImageFigure.this.setImage(ActionTriggerImageFigure.this.imageWFocus);
            }
        }
    }
}

