/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.internal.ui.palette.editparts.TemplateEditPart;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteTemplateEntry;
import org.eclipse.gef.ui.palette.DefaultPaletteViewerPreferences;
import org.eclipse.gef.ui.palette.PaletteContextMenuProvider;
import org.eclipse.gef.ui.palette.PaletteCustomizer;
import org.eclipse.gef.ui.palette.PaletteEditPartFactory;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerPreferences;
import org.eclipse.gef.ui.palette.customize.PaletteCustomizerDialog;
import org.eclipse.gef.ui.parts.PaletteViewerKeyHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.wst.common.snippets.core.ISnippetCategory;
import org.eclipse.wst.common.snippets.core.ISnippetItem;
import org.eclipse.wst.common.snippets.core.ISnippetsEntry;
import org.eclipse.wst.common.snippets.internal.Logger;
import org.eclipse.wst.common.snippets.internal.PluginRecord;
import org.eclipse.wst.common.snippets.internal.SnippetDefinitions;
import org.eclipse.wst.common.snippets.internal.SnippetTransfer;
import org.eclipse.wst.common.snippets.internal.SnippetsMessages;
import org.eclipse.wst.common.snippets.internal.SnippetsPlugin;
import org.eclipse.wst.common.snippets.internal.SnippetsPluginImageHelper;
import org.eclipse.wst.common.snippets.internal.actions.DeleteCategoryAction;
import org.eclipse.wst.common.snippets.internal.actions.DeleteItemAction;
import org.eclipse.wst.common.snippets.internal.model.SnippetManager;
import org.eclipse.wst.common.snippets.internal.palette.SnippetCustomizerDialog;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteDrawer;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteItem;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteItemFactory;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteRoot;
import org.eclipse.wst.common.snippets.internal.ui.EntryDeserializer;
import org.eclipse.wst.common.snippets.internal.ui.EntrySerializer;
import org.eclipse.wst.common.snippets.internal.ui.SnippetsCustomizer;
import org.eclipse.wst.common.snippets.internal.util.UserDrawerSelector;
import org.eclipse.wst.common.snippets.internal.util.VisibilityUtil;
import org.eclipse.wst.common.snippets.ui.DefaultSnippetInsertion;
import org.eclipse.wst.common.snippets.ui.ISnippetInsertion;
import org.osgi.framework.Bundle;

public class SnippetsView
extends ViewPart {
    protected Clipboard clipboard = null;
    protected Action copyAction = null;
    protected Action cutAction = null;
    private Action deleteAction;
    private final String EMPTY_STRING = "";
    private PartActivationListener fPartActionUpdateListener = null;
    protected SnippetPaletteRoot fRoot = null;
    protected ISnippetsEntry fSelectedEntry;
    protected ISelectionChangedListener fSelectionChangedListener = null;
    protected List fTransferDragSourceListeners = null;
    protected PaletteViewer fViewer = null;
    protected Action insertAction = null;
    protected InsertionHelper insertionHelper = null;
    protected org.eclipse.swt.events.MouseListener insertListener = new InsertMouseListener();
    protected PasteAction pasteAction = null;
    private PaletteCustomizerDialog fPaletteCustomizerDialog = null;

    public SnippetsView() {
        this.insertionHelper = new InsertionHelper();
    }

    protected void addTextTransferListener() {
        TransferDragSourceListenerImpl listener = new TransferDragSourceListenerImpl((Transfer)TextTransfer.getInstance());
        this.getViewer().addDragSourceListener((TransferDragSourceListener)listener);
        this.getTransferDragSourceListeners().add(listener);
    }

    public void createPartControl(Composite parent) {
        this.fViewer = new PaletteViewer(){

            public PaletteCustomizerDialog getCustomizerDialog() {
                if (SnippetsView.this.fPaletteCustomizerDialog == null) {
                    SnippetsView.this.fPaletteCustomizerDialog = new SnippetCustomizerDialog(this.getControl().getShell(), this.getCustomizer(), this.getPaletteRoot());
                }
                return SnippetsView.this.fPaletteCustomizerDialog;
            }
        };
        this.fViewer.enableVerticalScrollbar(true);
        this.fViewer.createControl(parent);
        this.fViewer.setKeyHandler((KeyHandler)new PaletteViewerKeyHandler(this.fViewer){

            public boolean keyPressed(KeyEvent event) {
                if (event.keyCode == 13 && (event.stateMask & 0x40000) > 0 && SnippetsView.this.insertAction.isEnabled()) {
                    SnippetsView.this.insertAction.run();
                }
                return super.keyPressed(event);
            }
        });
        DefaultEditDomain domain = new DefaultEditDomain(null);
        this.fViewer.setEditDomain((EditDomain)domain);
        this.fillLocalMenu(this.getViewSite().getActionBars().getMenuManager());
        this.fillToolBar(this.getViewSite().getActionBars().getToolBarManager());
        this.getCopyAction().setEnabled(false);
        this.getCutAction().setEnabled(false);
        this.getPasteAction().setEnabled(false);
        this.getInsertAction().setEnabled(false);
        if (this.fViewer.getContextMenu() == null) {
            this.fViewer.setContextMenu(new MenuManager("#popup", ((Object)((Object)this)).getClass().getName()));
        }
        this.fViewer.getContextMenu().addMenuListener((IMenuListener)new SnippetsContextMenuListener(this.fViewer.getContextMenu()));
        this.fViewer.getContextMenu().setRemoveAllWhenShown(true);
        this.fViewer.setCustomizer((PaletteCustomizer)new SnippetsCustomizer());
        DefaultPaletteViewerPreferences palettePreferences = new DefaultPaletteViewerPreferences(SnippetsPlugin.getDefault().getPreferenceStore());
        SnippetsPlugin.getDefault().getPreferenceStore().setDefault("Auto-Collapse Setting", 2);
        this.fViewer.setPaletteViewerPreferences((PaletteViewerPreferences)palettePreferences);
        this.fViewer.setEditPartFactory((EditPartFactory)new WorkaroundPaletteEditPartFactory());
        this.fViewer.setPaletteRoot((PaletteRoot)this.getRoot());
        this.getViewer().addSelectionChangedListener(this.getSelectionChangedListener());
        this.fViewer.getControl().addMouseListener(this.insertListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getViewer().getControl(), "org.eclipse.wst.common.snippets.libv1000");
        this.fPartActionUpdateListener = new PartActivationListener();
        this.getViewSite().getPage().addPartListener((IPartListener)this.fPartActionUpdateListener);
    }

    protected PaletteRoot createRoot(SnippetDefinitions defs) {
        this.fRoot = new SnippetPaletteRoot(defs);
        this.fRoot.connect();
        return this.fRoot;
    }

    public void dispose() {
        super.dispose();
        if (this.fRoot != null) {
            this.fRoot.disconnect();
        }
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        if (this.fPartActionUpdateListener != null) {
            this.getViewSite().getPage().removePartListener((IPartListener)this.fPartActionUpdateListener);
        }
        this.save();
    }

    protected void fillContextMenu(IMenuManager mgr) {
        ISnippetsEntry entry = null;
        EditPart part = this.getViewer().getFocusEditPart();
        if (part != null && part.getModel() instanceof ISnippetsEntry) {
            entry = (ISnippetsEntry)part.getModel();
        }
        if (entry != null) {
            if (this.getInsertAction().isEnabled()) {
                mgr.add((IAction)this.getInsertAction());
                mgr.add((IContributionItem)new Separator());
            }
            mgr.add((IAction)this.getCutAction());
            mgr.add((IAction)this.getCopyAction());
            mgr.add((IAction)this.getPasteAction());
        }
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.getInsertAction());
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.getCutAction());
        manager.add((IAction)this.getCopyAction());
        manager.add((IAction)this.getPasteAction());
    }

    protected void fillToolBar(IToolBarManager manager) {
        manager.add((IAction)this.getInsertAction());
    }

    public Object getAdapter(Class adapter) {
        return super.getAdapter(adapter);
    }

    protected Clipboard getClipboard() {
        if (this.clipboard == null && this.getViewer() != null && this.getViewer().getControl() != null && !this.getViewer().getControl().isDisposed()) {
            this.clipboard = new Clipboard(this.getViewer().getControl().getDisplay());
        }
        return this.clipboard;
    }

    public Action getCopyAction() {
        if (this.copyAction == null) {
            this.copyAction = new CopyAction();
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.copyAction, "org.eclipse.wst.common.snippets.snip0060");
        }
        return this.copyAction;
    }

    public Action getCutAction() {
        if (this.cutAction == null) {
            this.cutAction = new CutAction();
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.cutAction, "org.eclipse.wst.common.snippets.snip0050");
        }
        return this.cutAction;
    }

    protected Action getDeleteAction() {
        if (this.deleteAction == null) {
            this.deleteAction = new DeleteAction();
        }
        return this.deleteAction;
    }

    protected ISnippetsEntry getEntryFromSelection(ISelection selection) {
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj instanceof EditPart) {
                if (((EditPart)obj).getModel() instanceof ISnippetsEntry) {
                    return (ISnippetsEntry)((EditPart)obj).getModel();
                }
            } else if (obj instanceof ISnippetsEntry) {
                return (ISnippetsEntry)obj;
            }
        }
        return null;
    }

    public Action getInsertAction() {
        if (this.insertAction == null) {
            this.insertAction = new InsertAction();
        }
        return this.insertAction;
    }

    public PasteAction getPasteAction() {
        if (this.pasteAction == null) {
            this.pasteAction = new PasteAction();
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.pasteAction, "org.eclipse.wst.common.snippets.snip0070");
        }
        return this.pasteAction;
    }

    public SnippetPaletteRoot getRoot() {
        return SnippetManager.getInstance().getPaletteRoot();
    }

    public ISnippetsEntry getSelectedEntry() {
        return this.fSelectedEntry;
    }

    private ISelectionChangedListener getSelectionChangedListener() {
        if (this.fSelectionChangedListener == null) {
            this.fSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    SnippetsView.this.setSelectedEntry(SnippetsView.this.getEntryFromSelection(event.getSelection()));
                }
            };
        }
        return this.fSelectionChangedListener;
    }

    public List getTransferDragSourceListeners() {
        if (this.fTransferDragSourceListeners == null) {
            this.fTransferDragSourceListeners = new ArrayList();
        }
        return this.fTransferDragSourceListeners;
    }

    public PaletteViewer getViewer() {
        return this.fViewer;
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (this.fViewer != null) {
            this.fViewer.restoreState(memento);
        }
    }

    public void insert() {
        if (this.getSelectedEntry() != null && this.getSelectedEntry() instanceof ISnippetItem) {
            SnippetPaletteItem item = (SnippetPaletteItem)this.getSelectedEntry();
            this.insert(item);
        }
    }

    public void insert(SnippetPaletteItem item) {
        this.insertionHelper.insert(item, this.getSite().getPage().getActiveEditor());
    }

    public void save() {
        SnippetManager.getInstance().saveDefinitions();
    }

    public void saveState(IMemento memento) {
        this.save();
        this.fViewer.saveState(memento);
    }

    public void setFocus() {
        if (this.getViewer() != null && this.getViewer().getControl() != null && !this.getViewer().getControl().isDisposed()) {
            this.getViewer().getControl().setFocus();
        }
    }

    public void setRoot(SnippetPaletteRoot root) {
        this.fRoot = root;
        this.fViewer.setPaletteRoot((PaletteRoot)root);
    }

    public void setSelectedEntry(ISnippetsEntry entry) {
        if (Logger.DEBUG_PALETTE_SELECTION) {
            if (this.fSelectedEntry == entry) {
                System.out.println("selection notification: " + String.valueOf(entry) + " (duplicated)");
            } else {
                System.out.println("selection notification: " + String.valueOf(entry));
            }
        }
        if (this.fSelectedEntry == entry) {
            return;
        }
        if (Logger.DEBUG_PALETTE_SELECTION) {
            System.out.println("processing selection: " + String.valueOf(entry));
        }
        this.fSelectedEntry = entry;
        this.updateDragSource();
        this.updateActions(entry);
    }

    protected void updateActions(ISnippetsEntry entry) {
        boolean isItem = entry instanceof ISnippetItem;
        boolean isFromPlugin = entry != null && entry.getSourceType() == "PLUGINS";
        this.getCopyAction().setEnabled(entry != null && isItem);
        this.getCutAction().setEnabled(entry != null && isItem && !isFromPlugin);
        this.getPasteAction().setEnabled(this.getClipboard().getContents((Transfer)TextTransfer.getInstance()) != null);
        this.getPasteAction().update();
        this.getInsertAction().setEnabled(entry != null && isItem && this.getSite().getPage().getEditorReferences().length > 0);
    }

    protected void updateDragSource() {
        Transfer[] supportedTypes = null;
        if (this.getSelectedEntry() != null && this.getSelectedEntry() instanceof ISnippetItem) {
            SnippetPaletteItem item = (SnippetPaletteItem)this.getSelectedEntry();
            ISnippetInsertion insertion = this.insertionHelper.getInsertion(item);
            if (insertion != null) {
                insertion.setItem(item);
                insertion.setEditorPart(this.getSite().getPage().getActiveEditor());
                supportedTypes = insertion.getTransfers();
            } else {
                supportedTypes = new Transfer[]{TextTransfer.getInstance()};
            }
        } else {
            supportedTypes = new Transfer[]{TextTransfer.getInstance()};
        }
        Iterator iterator = this.getTransferDragSourceListeners().iterator();
        ArrayList<TransferDragSourceListener> oldListeners = new ArrayList<TransferDragSourceListener>();
        while (iterator.hasNext()) {
            TransferDragSourceListener listener = (TransferDragSourceListener)iterator.next();
            oldListeners.add(listener);
            iterator.remove();
        }
        boolean addTextTransfer = false;
        int i = 0;
        while (i < supportedTypes.length) {
            if (TextTransfer.class.equals(supportedTypes[i].getClass())) {
                addTextTransfer = true;
            } else {
                TransferDragSourceListenerImpl listener = new TransferDragSourceListenerImpl(supportedTypes[i]);
                this.getViewer().addDragSourceListener((TransferDragSourceListener)listener);
                this.getTransferDragSourceListeners().add(listener);
            }
            ++i;
        }
        iterator = oldListeners.iterator();
        while (iterator.hasNext()) {
            TransferDragSourceListener listener = (TransferDragSourceListener)iterator.next();
            this.getViewer().removeDragSourceListener(listener);
            iterator.remove();
        }
        if (addTextTransfer) {
            this.addTextTransferListener();
        }
        if (Logger.DEBUG_DRAG_AND_DROP) {
            System.out.println(this.getTransferDragSourceListeners().size() + " transfer types");
        }
    }

    protected class CopyAction
    extends Action {
        public CopyAction() {
            super(SnippetsMessages.Copy_2);
            this.setImageDescriptor(SnippetsPluginImageHelper.getInstance().getImageDescriptor("icons/full/elcl16/copy.gif"));
            this.setHoverImageDescriptor(SnippetsPluginImageHelper.getInstance().getImageDescriptor("icons/full/clcl16/copy.gif"));
            this.setDisabledImageDescriptor(SnippetsPluginImageHelper.getInstance().getImageDescriptor("icons/full/dlcl16/copy.gif"));
            this.setToolTipText(this.getText());
        }

        public void run() {
            super.run();
            byte[] stringData = EntrySerializer.getInstance().toXML(SnippetsView.this.getSelectedEntry());
            SnippetsView.this.getClipboard().setContents(new Object[]{stringData, SnippetsView.this.getSelectedEntry().getLabel()}, new Transfer[]{SnippetTransfer.getTransferInstance(), TextTransfer.getInstance()});
        }
    }

    protected class CutAction
    extends Action {
        public CutAction() {
            super(SnippetsMessages.Cut_2);
            this.setImageDescriptor(SnippetsPluginImageHelper.getInstance().getImageDescriptor("icons/full/elcl16/cut.gif"));
            this.setHoverImageDescriptor(SnippetsPluginImageHelper.getInstance().getImageDescriptor("icons/full/clcl16/cut.gif"));
            this.setDisabledImageDescriptor(SnippetsPluginImageHelper.getInstance().getImageDescriptor("icons/full/dlcl16/cut.gif"));
            this.setToolTipText(this.getText());
        }

        public void run() {
            super.run();
            SnippetsView.this.getCopyAction().run();
            SnippetsView.this.getDeleteAction().run();
            SnippetsView.this.save();
        }
    }

    protected class DeleteAction
    extends Action {
        public DeleteAction() {
            super(SnippetsMessages.Delete_1);
            this.setImageDescriptor(SnippetsPluginImageHelper.getInstance().getImageDescriptor("icons/full/elcl16/delete.gif"));
            this.setHoverImageDescriptor(SnippetsPluginImageHelper.getInstance().getImageDescriptor("icons/full/clcl16/delete.gif"));
            this.setDisabledImageDescriptor(SnippetsPluginImageHelper.getInstance().getImageDescriptor("icons/full/dlcl16/delete.gif"));
            this.setToolTipText(this.getText());
        }

        public void run() {
            super.run();
            if (SnippetsView.this.getSelectedEntry() instanceof PaletteContainer) {
                new DeleteCategoryAction(SnippetsView.this, (PaletteContainer)SnippetsView.this.getSelectedEntry()).run();
            } else if (SnippetsView.this.getSelectedEntry() instanceof PaletteEntry) {
                new DeleteItemAction((GraphicalViewer)SnippetsView.this.getViewer(), (PaletteEntry)SnippetsView.this.getSelectedEntry()).run();
            }
            SnippetsView.this.save();
        }
    }

    protected class InsertAction
    extends Action {
        public InsertAction() {
            super(SnippetsMessages.Insert___);
            this.setImageDescriptor(SnippetsPluginImageHelper.getInstance().getImageDescriptor("icons/full/elcl16/insert.gif"));
            this.setHoverImageDescriptor(SnippetsPluginImageHelper.getInstance().getImageDescriptor("icons/full/clcl16/insert.gif"));
            this.setDisabledImageDescriptor(SnippetsPluginImageHelper.getInstance().getImageDescriptor("icons/full/dlcl16/insert.gif"));
            this.setToolTipText(this.getText());
            this.setAccelerator(262157);
        }

        public void run() {
            super.run();
            SnippetsView.this.insert();
        }
    }

    protected class InsertMouseListener
    extends MouseAdapter {
        protected InsertMouseListener() {
        }

        public void mouseDoubleClick(org.eclipse.swt.events.MouseEvent e) {
            if (e.button == 1) {
                EditPart part = SnippetsView.this.getViewer().findObjectAt(new Point(e.x, e.y));
                SnippetPaletteItem item = null;
                if (part != null && part.getModel() instanceof SnippetPaletteItem) {
                    item = (SnippetPaletteItem)part.getModel();
                }
                if (item != null) {
                    SnippetsView.this.insert(item);
                }
            }
        }
    }

    class InsertionHelper {
        protected InsertionHelper() {
        }

        protected ISnippetInsertion getInsertion(SnippetPaletteItem item) {
            ISnippetInsertion insertion = null;
            String className = item.getClassName();
            PluginRecord record = null;
            if (item.getSourceType() == "PLUGINS") {
                record = (PluginRecord)item.getSourceDescriptor();
            }
            if (record != null && record.getPluginName() != null && className != null) {
                Class theClass;
                block12: {
                    theClass = null;
                    Bundle bundle = Platform.getBundle((String)record.getPluginName());
                    try {
                        if (className != null && className.length() > 0) {
                            theClass = bundle.loadClass(className);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        try {
                            theClass = Class.forName(className);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            Logger.logException("Could not load Insertion class", e);
                        }
                        if (theClass != null) break block12;
                        Logger.logException("Could not load Insertion class", e);
                    }
                }
                if (theClass != null) {
                    try {
                        insertion = (ISnippetInsertion)theClass.newInstance();
                    }
                    catch (IllegalAccessException e) {
                        Logger.logException("Could not access Insertion class", e);
                    }
                    catch (InstantiationException e) {
                        Logger.logException("Could not instantiate Insertion class", e);
                    }
                }
            }
            if (insertion == null) {
                insertion = item.getProvider() != null ? item.getProvider().getSnippetInsertion() : new DefaultSnippetInsertion();
            }
            return insertion;
        }

        public boolean insert(SnippetPaletteItem item, IEditorPart editorPart) {
            ISnippetInsertion insertion = this.getInsertion(item);
            if (insertion != null) {
                insertion.setItem(item);
                insertion.insert(editorPart);
                return true;
            }
            return false;
        }
    }

    private final class PartActivationListener
    implements IPartListener {
        private PartActivationListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            IEditorPart editorPart;
            IEditorInput input;
            if (part instanceof IEditorPart && (input = (editorPart = (IEditorPart)part).getEditorInput()).getName() != null) {
                SnippetDefinitions snippetDefinitions = SnippetManager.getInstance().getDefinitions();
                List<ISnippetCategory> categories = snippetDefinitions.getCategories();
                for (SnippetPaletteDrawer snippetPaletteDrawer : categories) {
                    String[] filters = snippetPaletteDrawer.getFilters();
                    boolean drawerVisibility = VisibilityUtil.isContentType(input, filters);
                    snippetPaletteDrawer.setVisible(drawerVisibility);
                }
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            SnippetsView.this.updateActions(SnippetsView.this.getSelectedEntry());
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
            SnippetsView.this.updateActions(SnippetsView.this.getSelectedEntry());
        }
    }

    protected class PasteAction
    extends Action {
        public PasteAction() {
            super(SnippetsMessages.Paste_4);
            this.setImageDescriptor(SnippetsPluginImageHelper.getInstance().getImageDescriptor("icons/full/elcl16/paste.gif"));
            this.setHoverImageDescriptor(SnippetsPluginImageHelper.getInstance().getImageDescriptor("icons/full/clcl16/paste.gif"));
            this.setDisabledImageDescriptor(SnippetsPluginImageHelper.getInstance().getImageDescriptor("icons/full/dlcl16/paste.gif"));
            this.setToolTipText(this.getText());
        }

        protected String getFirstLine(String text) {
            if (text == null || text.length() < 1) {
                return text;
            }
            Document doc = new Document(text);
            try {
                int lineNumber = doc.getLineOfOffset(0);
                IRegion line = doc.getLineInformation(lineNumber);
                return doc.get(line.getOffset(), line.getLength());
            }
            catch (BadLocationException badLocationException) {
                return text;
            }
        }

        protected void launchCustomizer(PaletteEntry entry) {
            PaletteCustomizerDialog dialog = SnippetsView.this.getViewer().getCustomizerDialog();
            if (!(entry instanceof PaletteRoot)) {
                dialog.setDefaultSelection(entry);
            }
            dialog.open();
        }

        public void run() {
            super.run();
            byte[] itemDefinition = (byte[])SnippetsView.this.getClipboard().getContents((Transfer)SnippetTransfer.getTransferInstance());
            if (itemDefinition != null) {
                ISnippetsEntry entry = EntryDeserializer.getInstance().fromXML(itemDefinition);
                ISnippetsEntry destination = SnippetsView.this.getSelectedEntry();
                if (destination == null || destination.getSourceType() == "PLUGINS") {
                    UserDrawerSelector selector = new UserDrawerSelector(SnippetsView.this.getSite().getShell());
                    selector.setSelectionPrompt(SnippetsMessages.Cant_add_to_this);
                    SnippetPaletteDrawer drawer = (SnippetPaletteDrawer)selector.getUserDrawer();
                    if (drawer != null) {
                        destination = drawer;
                        drawer.add((SnippetPaletteItem)entry);
                    } else {
                        return;
                    }
                }
                if (entry instanceof SnippetPaletteItem) {
                    SnippetPaletteItem item = (SnippetPaletteItem)entry;
                    if (destination instanceof SnippetPaletteDrawer) {
                        item.setId(((SnippetPaletteDrawer)destination).getId() + System.currentTimeMillis());
                        ((SnippetPaletteDrawer)destination).add(item);
                        EditPart container = (EditPart)SnippetsView.this.getViewer().getEditPartRegistry().get(destination);
                        container.refresh();
                    } else if (destination instanceof ISnippetItem) {
                        SnippetPaletteDrawer category = (SnippetPaletteDrawer)((ISnippetItem)destination).getCategory();
                        item.setId("item_" + System.currentTimeMillis());
                        category.add(item);
                        EditPart container = (EditPart)SnippetsView.this.getViewer().getEditPartRegistry().get(category);
                        container.refresh();
                    }
                    EditPart part = (EditPart)SnippetsView.this.getViewer().getEditPartRegistry().get(item);
                    if (part != null) {
                        SnippetsView.this.getViewer().select(part);
                    }
                }
                SnippetsView.this.save();
            } else {
                String itemText = (String)SnippetsView.this.getClipboard().getContents((Transfer)TextTransfer.getInstance());
                if (itemText == null) {
                    itemText = "";
                }
                ISnippetCategory category = null;
                ISnippetsEntry entry = SnippetsView.this.getSelectedEntry();
                if (entry == null || entry.getSourceType() == "PLUGINS") {
                    UserDrawerSelector selector = new UserDrawerSelector(SnippetsView.this.getSite().getShell());
                    selector.setSelectionPrompt(SnippetsMessages.Cant_add_to_this);
                    SnippetPaletteDrawer drawer = (SnippetPaletteDrawer)selector.getUserDrawer();
                    if (drawer != null) {
                        entry = drawer;
                    } else {
                        return;
                    }
                }
                if (entry instanceof ISnippetItem) {
                    category = ((ISnippetItem)SnippetsView.this.getSelectedEntry()).getCategory();
                } else if (entry instanceof ISnippetCategory) {
                    category = (ISnippetCategory)entry;
                }
                if (category == null) {
                    return;
                }
                SnippetPaletteItem item = (SnippetPaletteItem)new SnippetPaletteItemFactory().createNewEntry(SnippetsView.this.getViewer().getControl().getShell(), (PaletteEntry)category);
                item.setDescription(this.getFirstLine(itemText));
                item.setContentString(itemText);
                this.launchCustomizer((PaletteEntry)item);
            }
        }

        public void update() {
            if (SnippetsView.this.getClipboard().getContents((Transfer)SnippetTransfer.getTransferInstance()) == null && SnippetsView.this.getClipboard().getContents((Transfer)TextTransfer.getInstance()) != null) {
                this.setText(SnippetsMessages.Paste_as_Snippet);
            } else {
                this.setText(SnippetsMessages.Paste_4);
            }
            this.setToolTipText(this.getText());
        }
    }

    protected class SnippetsContextMenuListener
    implements IMenuListener {
        protected PaletteContextMenuProvider baseProvider = null;
        protected IMenuManager manager = null;

        public SnippetsContextMenuListener(MenuManager mgr) {
            this.manager = mgr;
            this.baseProvider = new PaletteContextMenuProvider(SnippetsView.this.getViewer());
        }

        public void menuAboutToShow(IMenuManager menuManager) {
            SnippetsView.this.fillContextMenu(menuManager);
            this.baseProvider.buildContextMenu(menuManager);
        }
    }

    protected class TransferDragSourceListenerImpl
    implements TransferDragSourceListener {
        private Transfer fTransfer;

        public TransferDragSourceListenerImpl(Transfer xfer) {
            this.fTransfer = xfer;
        }

        public void dragFinished(DragSourceEvent event) {
            if (Logger.DEBUG_DRAG_AND_DROP) {
                System.out.println("drag finished");
            }
        }

        public void dragSetData(DragSourceEvent event) {
            if (SnippetsView.this.getSelectedEntry() == null) {
                return;
            }
            if (SnippetsView.this.getSelectedEntry() instanceof ISnippetItem) {
                ISnippetInsertion insertion = SnippetsView.this.insertionHelper.getInsertion((SnippetPaletteItem)SnippetsView.this.getSelectedEntry());
                insertion.setEditorPart(SnippetsView.this.getSite().getPage().getActiveEditor());
                insertion.dragSetData(event, (ISnippetItem)SnippetsView.this.getSelectedEntry());
            } else {
                event.data = SnippetsView.this.getSelectedEntry() != null ? SnippetsView.this.getSelectedEntry().getLabel() : "";
            }
        }

        public void dragStart(DragSourceEvent event) {
            if (Logger.DEBUG_DRAG_AND_DROP) {
                System.out.println("drag begun");
            }
        }

        public Transfer getTransfer() {
            return this.fTransfer;
        }
    }

    static class WorkaroundEditPart
    extends TemplateEditPart {
        WorkaroundEditPart(PaletteTemplateEntry entry) {
            super(entry);
        }

        public IFigure createFigure() {
            IFigure fig = super.createFigure();
            fig.addMouseListener((MouseListener)new WorkaroundMouseListener());
            return fig;
        }
    }

    static class WorkaroundMouseListener
    implements MouseListener {
        WorkaroundMouseListener() {
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }

        public void mousePressed(MouseEvent me) {
        }

        public void mouseReleased(MouseEvent me) {
        }
    }

    static class WorkaroundPaletteEditPartFactory
    extends PaletteEditPartFactory {
        WorkaroundPaletteEditPartFactory() {
        }

        protected EditPart createTemplateEditPart(EditPart parentEditPart, Object model) {
            WorkaroundEditPart created = new WorkaroundEditPart((PaletteTemplateEntry)model);
            return created;
        }
    }
}

