/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.js.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.wst.jsdt.core.runtime.IJSRunner;
import org.eclipse.wst.jsdt.core.runtime.IJSRuntimeInstall;
import org.eclipse.wst.jsdt.core.runtime.JSRuntimeManager;

public final class LaunchConfigurationUtil {
    private static final String ID_CHROME_PROCESS_TYPE = "Chrome / Chromium";

    private LaunchConfigurationUtil() {
    }

    public static Map<String, String> getDefaultAttributes() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(IProcess.ATTR_PROCESS_TYPE, ID_CHROME_PROCESS_TYPE);
        return map;
    }

    public static IJSRunner getJSRunner(ILaunchConfiguration configuration, String mode) throws CoreException {
        IJSRuntimeInstall runtimeInstall = LaunchConfigurationUtil.verifyJSRuntimeInstall(configuration);
        if (runtimeInstall != null) {
            return runtimeInstall.getJSRunner(mode);
        }
        return null;
    }

    public static String[] getEnvironment(ILaunchConfiguration configuration) throws CoreException {
        return DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
    }

    public static String getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        String appArguments = configuration.getAttribute("attr_app_arguments", "");
        return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(appArguments);
    }

    public static String getChromiumArguments(ILaunchConfiguration configuration) throws CoreException {
        String chromiumArguments = configuration.getAttribute("attr_chromium_arguments", "");
        String args = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(chromiumArguments);
        return args;
    }

    private static IJSRuntimeInstall verifyJSRuntimeInstall(ILaunchConfiguration configuration) throws CoreException {
        return LaunchConfigurationUtil.getJSRuntimeInstall(configuration);
    }

    private static IJSRuntimeInstall getJSRuntimeInstall(ILaunchConfiguration configuration) throws CoreException {
        return JSRuntimeManager.getDefaultRuntimeInstall((String)"org.eclipse.wst.jsdt.chromium.debug.js.runtimeType");
    }
}

