/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.IOException;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.i18n.CoreMessages;

public class ArchiveEntryOutputStream
extends RAOutputStream {
    protected ArchiveEntry entry;
    protected byte[] buffer;
    protected int buffer_offset;
    protected int buffer_size;
    private long offset;

    ArchiveEntryOutputStream(ArchiveEntry entry) {
        this.entry = entry;
        this.offset = 0L;
        this.buffer_offset = 0;
        this.buffer_size = 4096;
        this.buffer = new byte[4096];
        this.entry.setOutputStream(this);
    }

    @Override
    public long getOffset() throws IOException {
        return this.offset + (long)this.buffer_offset;
    }

    @Override
    public void seek(long localPos) throws IOException {
        if (localPos < 0L) {
            throw new IOException(CoreMessages.getFormattedString("error.InvalidSeekOffset", localPos));
        }
        if (localPos > this.entry.getLength()) {
            this.entry.setLength(localPos);
        }
        if (this.offset + (long)this.buffer_offset != localPos) {
            this.flushBuffer();
            this.offset = localPos;
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.buffer_offset >= this.buffer_size) {
            this.flushBuffer();
        }
        this.buffer[this.buffer_offset] = (byte)b;
        ++this.buffer_offset;
    }

    @Override
    public void writeInt(int value) throws IOException {
        if (this.buffer_offset + 4 >= this.buffer_size) {
            this.flushBuffer();
        }
        ArchiveUtil.integerToBytes(value, this.buffer, this.buffer_offset);
        this.buffer_offset += 4;
    }

    @Override
    public void writeLong(long value) throws IOException {
        if (this.buffer_offset + 8 >= this.buffer_size) {
            this.flushBuffer();
        }
        ArchiveUtil.longToBytes(value, this.buffer, this.buffer_offset);
        this.buffer_offset += 8;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.buffer_offset + len <= this.buffer_size) {
            System.arraycopy(b, off, this.buffer, this.buffer_offset, len);
            this.buffer_offset += len;
            return;
        }
        this.flushBuffer();
        this.entry.write(this.offset, b, off, len);
        this.offset += (long)len;
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
    }

    @Override
    public void close() throws IOException {
        if (this.entry != null) {
            this.entry.setOutputStream(null);
            try {
                this.flush();
            }
            finally {
                try {
                    this.entry.close();
                }
                finally {
                    this.entry = null;
                }
            }
        }
    }

    private void flushBuffer() throws IOException {
        if (this.buffer_offset != 0) {
            this.entry.write(this.offset, this.buffer, 0, this.buffer_offset);
            this.offset += (long)this.buffer_offset;
            this.buffer_offset = 0;
        }
    }

    @Override
    public long length() throws IOException {
        long length = this.entry.getLength();
        long offset = this.getOffset();
        if (offset > length) {
            return offset;
        }
        return length;
    }
}

