/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.common.ui.util;

import com.ibm.icu.text.BreakIterator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.eclipse.swt.graphics.GC;

public class LineBreakingReader {
    private BufferedReader _fReader;
    private GC _fGC;
    private int _fMaxWidth;
    private String _fLine;
    private int _fOffset;
    private BreakIterator _fLineBreakIterator;

    public LineBreakingReader(Reader reader, GC gc, int maxLineWidth) {
        this._fReader = new BufferedReader(reader);
        this._fGC = gc;
        this._fMaxWidth = maxLineWidth;
        this._fOffset = 0;
        this._fLine = null;
        this._fLineBreakIterator = BreakIterator.getLineInstance();
    }

    public boolean isFormattedLine() {
        return this._fLine != null;
    }

    public String readLine() throws IOException {
        String res;
        int breakOffset;
        if (this._fLine == null) {
            String line = this._fReader.readLine();
            if (line == null) {
                return null;
            }
            int lineLen = this._fGC.textExtent((String)line).x;
            if (lineLen < this._fMaxWidth) {
                return line;
            }
            this._fLine = line;
            this._fLineBreakIterator.setText(line);
            this._fOffset = 0;
        }
        if ((breakOffset = this.findNextBreakOffset(this._fOffset)) != -1) {
            res = this._fLine.substring(this._fOffset, breakOffset);
            this._fOffset = this.findWordBegin(breakOffset);
            if (this._fOffset == this._fLine.length()) {
                this._fLine = null;
            }
        } else {
            res = this._fLine.substring(this._fOffset);
            this._fLine = null;
        }
        return res;
    }

    private int findNextBreakOffset(int currOffset) {
        int currWidth = 0;
        int nextOffset = this._fLineBreakIterator.following(currOffset);
        while (nextOffset != -1) {
            String word = this._fLine.substring(currOffset, nextOffset);
            int wordWidth = this._fGC.textExtent((String)word).x;
            int nextWidth = wordWidth + currWidth;
            if (nextWidth > this._fMaxWidth) {
                if (currWidth > 0) {
                    return currOffset;
                }
                return nextOffset;
            }
            currWidth = nextWidth;
            currOffset = nextOffset;
            nextOffset = this._fLineBreakIterator.next();
        }
        return nextOffset;
    }

    private int findWordBegin(int idx) {
        while (idx < this._fLine.length() && Character.isWhitespace(this._fLine.charAt(idx))) {
            ++idx;
        }
        return idx;
    }
}

