/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.colors;

import org.eclipse.pde.api.tools.annotations.NoExtend;
import org.eclipse.pde.api.tools.annotations.NoInstantiate;
import org.eclipse.pde.api.tools.annotations.NoReference;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

@NoExtend
@NoReference
@NoInstantiate
public record HSL(double h, double s, double l) {
    private static final double MAX_RGB_VALUE = 255.0;

    public HSL {
        if (h < 0.0 || h > 360.0) {
            SWT.error((int)5);
        }
        if (s < 0.0 || s > 1.0) {
            SWT.error((int)5);
        }
        if (l < 0.0 || l > 1.0) {
            SWT.error((int)5);
        }
    }

    public HSL darker(double percentage) {
        double newL = this.l * (1.0 - Math.max(0.0, Math.min(1.0, percentage)));
        return new HSL(this.h, this.s, newL);
    }

    public boolean isDark() {
        return this.l < 0.5;
    }

    public HSL lighter(double percentage) {
        double newL = this.l + (1.0 - this.l) * Math.max(0.0, Math.min(1.0, percentage));
        return new HSL(this.h, this.s, newL);
    }

    public static HSL fromColor(Color col) {
        return HSL.fromRGB(col.getRed(), col.getGreen(), col.getBlue());
    }

    public static HSL fromRGB(RGB rgb) {
        return HSL.fromRGB(rgb.red, rgb.green, rgb.blue);
    }

    public static HSL fromRGB(int r, int g, int b) {
        double rRel = (double)r / 255.0;
        double gRel = (double)g / 255.0;
        double bRel = (double)b / 255.0;
        double max = Math.max(Math.max(rRel, gRel), bRel);
        double min = Math.min(Math.min(rRel, gRel), bRel);
        double h = 0.0;
        double s = 0.0;
        double l = (max + min) / 2.0;
        if (max != min) {
            double delta = max - min;
            s = l <= 0.5 ? delta / (max + min) : delta / (2.0 - (max + min));
            if (Math.abs(max - rRel) <= Double.MIN_VALUE) {
                h = (gRel - bRel) / delta;
            } else if (Math.abs(max - gRel) <= Double.MIN_VALUE) {
                h = 2.0 + (bRel - rRel) / delta;
            } else if (Math.abs(max - bRel) <= Double.MIN_VALUE) {
                h = 4.0 + (rRel - gRel) / delta;
            }
            h *= 60.0;
            if (h < 0.0) {
                h += 360.0;
            }
        }
        return new HSL(h, s, l);
    }

    public Color toColor() {
        return new Color(this.toRGB());
    }

    public RGB toRGB() {
        RGB retVal = new RGB(0, 0, 0);
        if (this.s == 0.0) {
            if (this.h == 0.0) {
                retVal.green = retVal.blue = (int)(this.l * 255.0);
                retVal.red = retVal.blue;
            } else {
                SWT.error((int)5);
            }
        } else {
            double m2 = this.l <= 0.5 ? this.l * (1.0 + this.s) : this.l + this.s - this.l * this.s;
            double m1 = 2.0 * this.l - m2;
            retVal.red = HSL.hslValue(m1, m2, this.h + 120.0);
            retVal.green = HSL.hslValue(m1, m2, this.h);
            retVal.blue = HSL.hslValue(m1, m2, this.h - 120.0);
        }
        return retVal;
    }

    private static int hslValue(double m1, double m2, double hue) {
        double retVal = m1;
        if (hue > 360.0) {
            hue -= 360.0;
        } else if (hue < 0.0) {
            hue += 360.0;
        }
        if (hue < 60.0) {
            retVal = m1 + (m2 - m1) * hue / 60.0;
        } else if (hue < 180.0) {
            retVal = m2;
        } else if (hue < 240.0) {
            retVal = m1 + (m2 - m1) * (240.0 - hue) / 60.0;
        }
        return (int)Math.round(255.0 * retVal);
    }
}

