/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.nested;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.servlet.DispatcherType;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.ee8.nested.ContextHandler;
import org.eclipse.jetty.ee8.nested.Request;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.content.InputStreamContentSource;
import org.eclipse.jetty.server.Components;
import org.eclipse.jetty.server.ConnectionMetaData;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.HttpStream;
import org.eclipse.jetty.server.Session;
import org.eclipse.jetty.server.TunnelSupport;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.URIUtil;

public class ServletCoreRequest
implements org.eclipse.jetty.server.Request {
    private final HttpServletRequest _servletRequest;
    private final ContextHandler.CoreContextRequest _coreContextRequest;
    private final HttpFields _httpFields;
    private final HttpURI _uri;
    private final Attributes _attributes;
    private final boolean _wrapped;
    private Content.Source _source;

    public org.eclipse.jetty.server.Request wrap(HttpServletRequest httpServletRequest) {
        Request baseRequest = Objects.requireNonNull(Request.getBaseRequest((ServletRequest)httpServletRequest));
        ContextHandler.CoreContextRequest coreContextRequest = baseRequest.getCoreRequest();
        return new ServletCoreRequest(coreContextRequest, httpServletRequest, (Attributes)coreContextRequest);
    }

    ServletCoreRequest(ContextHandler.CoreContextRequest coreContextRequest, HttpServletRequest request, Attributes attributes) {
        this._servletRequest = request;
        this._wrapped = !(request instanceof org.eclipse.jetty.server.Request);
        this._coreContextRequest = coreContextRequest;
        this._attributes = attributes;
        HttpFields.Mutable fields = HttpFields.build((HttpFields)coreContextRequest.getHeaders());
        fields.clear();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Enumeration headerValues = request.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                String headerValue = (String)headerValues.nextElement();
                fields.add(new HttpField(headerName, headerValue));
            }
        }
        this._httpFields = fields.asImmutable();
        String includedServletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
        boolean included = includedServletPath != null;
        HttpURI.Mutable builder = HttpURI.build();
        builder.scheme(request.getScheme()).authority(request.getServerName(), request.getServerPort());
        if (request.getDispatcherType() != DispatcherType.REQUEST) {
            builder.path(URIUtil.addEncodedPaths((String)request.getContextPath(), (String)URIUtil.encodePath((String)URIUtil.addPaths((String)this._servletRequest.getServletPath(), (String)this._servletRequest.getPathInfo()))));
        } else {
            builder.path(request.getRequestURI());
        }
        builder.query(request.getQueryString());
        this._uri = builder.asImmutable();
        this._source = this._wrapped ? null : this._coreContextRequest;
    }

    private Content.Source source() throws IOException {
        if (this._source == null) {
            this._source = this._wrapped ? new InputStreamContentSource((InputStream)this.getServletRequest().getInputStream()) : this._coreContextRequest;
        }
        return this._source;
    }

    public HttpFields getHeaders() {
        return this._httpFields;
    }

    public HttpURI getHttpURI() {
        return this._uri;
    }

    public String getId() {
        return this._coreContextRequest.getId();
    }

    public String getMethod() {
        return this._servletRequest.getMethod();
    }

    public HttpServletRequest getServletRequest() {
        return this._servletRequest;
    }

    public boolean isSecure() {
        return this._servletRequest.isSecure();
    }

    public Object removeAttribute(String name) {
        return this._attributes.removeAttribute(name);
    }

    public Object setAttribute(String name, Object attribute) {
        return this._attributes.setAttribute(name, attribute);
    }

    public Object getAttribute(String name) {
        return this._attributes.getAttribute(name);
    }

    public Set<String> getAttributeNameSet() {
        return this._attributes.getAttributeNameSet();
    }

    public void clearAttributes() {
        this._attributes.clearAttributes();
    }

    public void fail(Throwable failure) {
        try {
            this.source().fail(failure);
        }
        catch (Throwable t) {
            ExceptionUtil.addSuppressedIfNotAssociated((Throwable)failure, (Throwable)t);
        }
    }

    public Components getComponents() {
        return this._coreContextRequest.getComponents();
    }

    public ConnectionMetaData getConnectionMetaData() {
        return this._coreContextRequest.getConnectionMetaData();
    }

    public Context getContext() {
        return this._coreContextRequest.getContext();
    }

    public void demand(Runnable demandCallback) {
        try {
            this.source().demand(demandCallback);
        }
        catch (Throwable t) {
            demandCallback.run();
        }
    }

    public HttpFields getTrailers() {
        return this._coreContextRequest.getTrailers();
    }

    public long getBeginNanoTime() {
        return this._coreContextRequest.getBeginNanoTime();
    }

    public long getHeadersNanoTime() {
        return this._coreContextRequest.getHeadersNanoTime();
    }

    public Content.Chunk read() {
        try {
            return this.source().read();
        }
        catch (Throwable t) {
            return Content.Chunk.from((Throwable)t, (boolean)true);
        }
    }

    public boolean consumeAvailable() {
        if (this._wrapped) {
            try {
                Content.Source.consumeAll((Content.Source)this.source());
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        return this._coreContextRequest.consumeAvailable();
    }

    public void addIdleTimeoutListener(Predicate<TimeoutException> onIdleTimeout) {
        this._coreContextRequest.addIdleTimeoutListener(onIdleTimeout);
    }

    public void addFailureListener(Consumer<Throwable> onFailure) {
        this._coreContextRequest.addFailureListener(onFailure);
    }

    public TunnelSupport getTunnelSupport() {
        return null;
    }

    public void addHttpStreamWrapper(Function<HttpStream, HttpStream> wrapper) {
        this._coreContextRequest.addHttpStreamWrapper(wrapper);
    }

    public Session getSession(boolean create) {
        return Session.getSession((Object)this._servletRequest.getSession(create));
    }

    public static class ServletAttributes
    implements Attributes {
        private final HttpServletRequest _servletRequest;
        private Set<String> _attributeNames;

        public ServletAttributes(HttpServletRequest httpServletRequest) {
            this._servletRequest = httpServletRequest;
        }

        public Object removeAttribute(String name) {
            Object value = this._servletRequest.getAttribute(name);
            if (value != null) {
                this._attributeNames = null;
            }
            this._servletRequest.removeAttribute(name);
            return value;
        }

        public Object setAttribute(String name, Object attribute) {
            Object value = this._servletRequest.getAttribute(name);
            if (value == null) {
                this._attributeNames = null;
            }
            this._servletRequest.setAttribute(name, attribute);
            return value;
        }

        public Object getAttribute(String name) {
            return this._servletRequest.getAttribute(name);
        }

        public Set<String> getAttributeNameSet() {
            Set<String> set = this._attributeNames;
            if (set == null) {
                set = new HashSet<String>();
                Enumeration e = this._servletRequest.getAttributeNames();
                while (e.hasMoreElements()) {
                    set.add((String)e.nextElement());
                }
                this._attributeNames = set;
            }
            return set;
        }

        public void clearAttributes() {
            Enumeration e = this._servletRequest.getAttributeNames();
            this._attributeNames = null;
            while (e.hasMoreElements()) {
                this._servletRequest.removeAttribute((String)e.nextElement());
            }
        }
    }
}

