/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.util.HashSet;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.model.internal.validation.AValidateHome;
import org.eclipse.jst.j2ee.model.internal.validation.IEJBValidationContext;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRule;
import org.eclipse.jst.j2ee.model.internal.validation.InvalidInputException;
import org.eclipse.jst.j2ee.model.internal.validation.MessageUtility;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationRuleUtility;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public abstract class AValidateEntityHome
extends AValidateHome {
    private HashSet findByPKMethods = new HashSet();

    @Override
    public void reset() {
        super.reset();
        this.findByPKMethods.clear();
    }

    protected void incrementFindByPrimaryKeyCount(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) {
        if (method == null) {
            return;
        }
        if (method.getName().equals("findByPrimaryKey")) {
            this.findByPKMethods.add(method);
        }
    }

    public boolean isSingleObjectFinder(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        vc.terminateIfCancelled();
        if (method == null) {
            return false;
        }
        JavaClass remoteIntf = bean.getRemoteInterface();
        ValidationRuleUtility.isValidTypeHierarchy(bean, (JavaHelpers)remoteIntf);
        return ValidationRuleUtility.isAssignableFrom(method.getReturnType(), (JavaHelpers)remoteIntf);
    }

    @Override
    public void primValidate(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method hiMethod) throws InvalidInputException {
        vc.terminateIfCancelled();
        String name = hiMethod.getName();
        if (name.equals("create")) {
            this.validateCreateMethod(vc, bean, clazz, hiMethod);
        } else if (name.startsWith("find")) {
            this.validateFindMethod(vc, bean, clazz, hiMethod);
        } else {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2005", 1, bean, clazz, hiMethod, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    @Override
    protected void primValidateExistence(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method ejbMethod) throws InvalidInputException {
        if ("findByPrimaryKey".equals(ejbMethod.getName())) {
            this.incrementFindByPrimaryKeyCount(vc, bean, clazz, ejbMethod);
        }
    }

    @Override
    public void validateClass(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws InvalidInputException {
        super.validateClass(vc, bean, clazz);
    }

    public void validateCreateMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        vc.terminateIfCancelled();
        if (method == null) {
            return;
        }
        this.validateCreateMethod_beanDep(vc, bean, clazz, method);
        vc.terminateIfCancelled();
        this.validateCreateMethod_remoteDep(vc, bean, clazz, method);
        if (!ValidationRuleUtility.throwsCreateException(bean, method)) {
            String[] msgParm = new String[]{"javax.ejb.CreateException"};
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2414", 1, bean, clazz, method, msgParm, (IValidationRule)this);
            vc.addMessage(message);
        }
        this.validateLegalRMIMethod(vc, bean, clazz, method);
    }

    @Override
    public void validateCreateMethod_beanDep(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        vc.terminateIfCancelled();
        if (method == null) {
            return;
        }
        super.validateCreateMethod_beanDep(vc, bean, clazz, method);
        this.validateMatchingBeanPostCreateMethod(vc, bean, clazz, method);
    }

    public void validateFindByPrimaryKeyMethod_keyDep(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        vc.terminateIfCancelled();
        if (method == null) {
            return;
        }
        boolean hasValidFBPKMethod = false;
        Entity entityBean = (Entity)bean;
        JavaClass keyClass = entityBean.getPrimaryKey();
        ValidationRuleUtility.isValidTypeHierarchy(bean, (JavaHelpers)keyClass);
        vc.terminateIfCancelled();
        JavaParameter[] parms = method.listParametersWithoutReturn();
        if (parms.length == 1) {
            JavaHelpers type = parms[0].getJavaType();
            if (ValidationRuleUtility.isAssignableFrom(type, (JavaHelpers)keyClass)) {
                if (this.isSingleObjectFinder(vc, bean, clazz, method)) {
                    hasValidFBPKMethod = true;
                }
            } else if (ValidationRuleUtility.isSameType(type, ValidationRuleUtility.getType("java.lang.Object", entityBean))) {
                hasValidFBPKMethod = true;
            }
        }
        if (!hasValidFBPKMethod) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2405", 2, bean, clazz, method, new String[]{keyClass.getQualifiedName()}, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    public void validateFindByPrimaryKeyMethod_remoteDep(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        vc.terminateIfCancelled();
        if (!this.isSingleObjectFinder(vc, bean, clazz, method)) {
            String remoteIntfName = bean.getRemoteInterface().getName();
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2403", 2, bean, clazz, method, new String[]{remoteIntfName}, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    public void validateFindMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        JavaHelpers retType;
        vc.terminateIfCancelled();
        if (method == null) {
            return;
        }
        this.validateFindMethod_remoteDep(vc, bean, clazz, method);
        if (!ValidationRuleUtility.throwsFinderException(bean, method)) {
            String[] msgParm = new String[]{"javax.ejb.FinderException"};
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2414", 1, bean, clazz, method, msgParm, (IValidationRule)this);
            vc.addMessage(message);
        }
        boolean validateRMIParameters = true;
        boolean validateRMIRetType = true;
        if (method.getName().equals("findByPrimaryKey")) {
            this.validateFindByPrimaryKeyMethod_keyDep(vc, bean, clazz, method);
            if (ValidationRuleUtility.usesUnknownPrimaryKey(bean)) {
                validateRMIParameters = false;
            }
        }
        boolean bl = validateRMIRetType = !ValidationRuleUtility.isAssignableFrom(retType = method.getReturnType(), ValidationRuleUtility.getType("java.util.Enumeration", bean)) && !ValidationRuleUtility.isAssignableFrom(retType, ValidationRuleUtility.getType("java.util.Collection", bean));
        if (validateRMIParameters) {
            this.validateLegalRMIMethodArguments(vc, bean, clazz, method);
        }
        if (validateRMIRetType) {
            this.validateLegalRMIMethodReturnType(vc, bean, clazz, method);
        }
        this.validateLegalRMIMethodExceptions(vc, bean, clazz, method);
    }

    public void validateFindMethod_remoteDep(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        JavaHelpers returnType;
        vc.terminateIfCancelled();
        if (method == null) {
            return;
        }
        JavaClass remoteIntf = bean.getRemoteInterface();
        ValidationRuleUtility.isValidTypeHierarchy(bean, (JavaHelpers)remoteIntf);
        if (!(method.getName().equals("findByPrimaryKey") || ValidationRuleUtility.isAssignableFromCollection(returnType = method.getReturnType(), bean) || ValidationRuleUtility.isAssignableFromEnumeration(returnType, bean) || ValidationRuleUtility.isAssignableFrom(returnType, (JavaHelpers)remoteIntf))) {
            String[] msgParm = new String[]{remoteIntf.getName()};
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2403", 2, bean, clazz, method, msgParm, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (method.getName().equals("findByPrimaryKey")) {
            this.validateFindByPrimaryKeyMethod_remoteDep(vc, bean, clazz, method);
        }
    }

    @Override
    public void validateMatchingBeanCreateMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        vc.terminateIfCancelled();
        super.validateMatchingBeanCreateMethod(vc, bean, clazz, method);
        JavaClass beanClass = bean.getEjbClass();
        Method ejbCreateMethod = ValidationRuleUtility.getMethodExtended(beanClass, method, "ejbCreate");
        if (ejbCreateMethod == null) {
            return;
        }
    }

    public void validateMatchingBeanFindMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method homeMethod) throws InvalidInputException {
        vc.terminateIfCancelled();
        if (homeMethod == null) {
            return;
        }
        String findMethodName = "ejbF" + homeMethod.getName().substring(1);
        JavaClass beanClass = bean.getEjbClass();
        ValidationRuleUtility.isValidTypeHierarchy(bean, (JavaHelpers)beanClass);
        Method beanMethod = ValidationRuleUtility.getMethodExtended(beanClass, homeMethod, findMethodName);
        if (beanMethod == null) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2030", 1, bean, clazz, homeMethod, new String[]{beanClass.getName()}, (IValidationRule)this);
            vc.addMessage(message);
            return;
        }
        vc.terminateIfCancelled();
        JavaHelpers homeRetType = homeMethod.getReturnType();
        JavaHelpers beanRetType = beanMethod.getReturnType();
        if (!ValidationRuleUtility.isAssignableFrom(homeRetType, beanRetType)) {
            boolean homeRetTypeIsRemote = ValidationRuleUtility.isAssignableFrom(homeRetType, (JavaHelpers)bean.getRemoteInterface());
            boolean beanRetTypeIsKey = ValidationRuleUtility.isAssignableFrom(beanRetType, (JavaHelpers)((Entity)bean).getPrimaryKey());
            if (!homeRetTypeIsRemote || !beanRetTypeIsKey) {
                JavaHelpers retType = beanRetTypeIsKey ? bean.getRemoteInterface() : beanRetType;
                IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2415", 1, bean, clazz, homeMethod, new String[]{retType.getJavaName(), beanClass.getName()}, (IValidationRule)this);
                vc.addMessage(message);
            }
        }
    }

    public void validateMatchingBeanPostCreateMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method homeMethod) throws InvalidInputException {
        vc.terminateIfCancelled();
        if (homeMethod == null) {
            return;
        }
        JavaClass beanClass = bean.getEjbClass();
        ValidationRuleUtility.isValidTypeHierarchy(bean, (JavaHelpers)beanClass);
        Method beanMethod = ValidationRuleUtility.getMethodExtended(beanClass, homeMethod, "ejbPostCreate");
        if (beanMethod == null) {
            return;
        }
    }

    @Override
    protected void validateMethodExists(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws InvalidInputException {
        if (this.findByPKMethods.size() == 0) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2011", 1, bean, clazz, new String[]{clazz.getQualifiedName()}, (IValidationRule)this);
            vc.addMessage(message);
        }
    }
}

